set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9826038';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-11-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0240',
      NULL,
      64,
      91.948788,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '403242',
      1,
      NULL,
      22.227089,
      16,
      1,
      NULL,
      NULL,
      0.976838,
      1.562662,
      1,
      1,
      1.084025,
      0.026771,
      1.484659,
      0.626408,
      0,
      8,
      0.298736,
      0.858988,
      0.987636,
      1,
      NULL,
      1,
      0.461132,
      0.696487,
      1.926199,
      1.653444,
      0.964930,
      0,
      NULL,
      0,
      NULL,
      0.050701,
      0.250044,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      1.447248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.083972,
      3.223924,
      1.329252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.603509,
      3.432564,
      0,
      1.390633,
      NULL,
      1.887743,
      NULL,
      1.908956,
      1.120387,
      0.665345,
      1,
      1.741022,
      0.360570,
      NULL,
      NULL,
      0,
      1.758643,
      0,
      1.871549,
      NULL,
      0.776054,
      2.784960,
      4,
      1.546138,
      1,
      0,
      4.996668,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.836434,
      2.985680,
      2.975168,
      2,
      1,
      5,
      6,
      4,
      NULL,
      3,
      1,
      9.130943,
      8,
      0.580910,
      0.937504,
      2,
      0.524926,
      1,
      1,
      2.923712,
      1.734596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.193383,
      NULL,
      0,
      1,
      0.316903,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.695082,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1.249621,
      0.657773,
      NULL,
      NULL,
      NULL,
      6.889060,
      NULL,
      7,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.422322,
      3.492162,
      1,
      1.225653,
      1.729383,
      0,
      3,
      NULL,
      2.506120,
      1.189713,
      0.736916,
      1.161009,
      1,
      0.582658,
      0,
      1,
      0.732290,
      1.837288,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.737394,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '14410',
      '12244',
      NULL,
      0.709835,
      '',
      NULL,
      '',
      2,
      '24200',
      '',
      NULL,
      0,
      6,
      NULL,
      1,
      NULL,
      0.841501,
      1.323865,
      0.084972,
      NULL);
commit;
end;
/


