set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9826038';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-5-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0112',
      '23040002',
      NULL,
      71.968045,
      '4323234',
      15.419488,
      NULL,
      2.110448,
      NULL,
      '043422',
      NULL,
      ' 6-17-2000',
      27.881694,
      34.184655,
      NULL,
      NULL,
      1,
      0,
      1.445676,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      0.568860,
      0.365752,
      0,
      1,
      0,
      0.258436,
      6.174903,
      NULL,
      NULL,
      0,
      0.334522,
      1,
      0.060611,
      NULL,
      2,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.050613,
      NULL,
      NULL,
      1.278938,
      1,
      1,
      0.823377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.299710,
      1.120157,
      0.967371,
      1.857637,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.579329,
      0.069028,
      4.347083,
      0.123208,
      3,
      0.723890,
      NULL,
      5,
      1.700170,
      0.582067,
      0.485564,
      5.664501,
      1,
      NULL,
      1.955475,
      1.522662,
      0.462697,
      NULL,
      1.579441,
      1.950543,
      1,
      1.847432,
      1.801058,
      0.563413,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0.473563,
      3,
      3,
      5,
      3.527365,
      3,
      0.577155,
      1,
      8,
      8,
      1,
      1.785500,
      1,
      0.764321,
      0.135049,
      3,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      1,
      1.957398,
      NULL,
      1.041319,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.685347,
      NULL,
      NULL,
      NULL,
      NULL,
      1.738475,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.154864,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.888519,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.834250,
      0.840480,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.538907,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.321465,
      NULL,
      0.830397,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '22240',
      '03113',
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      4,
      9.415624,
      0.270929,
      NULL,
      1.608972,
      3,
      2,
      3.164251,
      0);
commit;
end;
/


