set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9100111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-9-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '2',
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      2,
      '212041',
      1,
      NULL,
      40.563981,
      NULL,
      0,
      NULL,
      0,
      1.791661,
      0.677316,
      1.312933,
      1.868695,
      3,
      NULL,
      1,
      0.458624,
      0.552880,
      0.510714,
      0.359036,
      1.678051,
      0,
      NULL,
      6.282355,
      0,
      0.790544,
      0,
      0,
      0.435841,
      0,
      3,
      NULL,
      0.732740,
      0,
      0.148967,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.394676,
      1.888745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.937220,
      2.636489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.871860,
      0.272610,
      0.745959,
      1,
      NULL,
      1.327807,
      NULL,
      NULL,
      NULL,
      1.420520,
      0,
      1.550850,
      0.334450,
      1,
      NULL,
      1.179441,
      1.222457,
      1,
      0.204565,
      NULL,
      0.948305,
      5.893450,
      NULL,
      1,
      3.426286,
      NULL,
      4,
      NULL,
      5,
      4,
      5.822489,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0.723057,
      NULL,
      9,
      3,
      NULL,
      1,
      0,
      3.388641,
      NULL,
      2,
      19.656630,
      7,
      2,
      1.608771,
      0.439511,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.124202,
      0.185846,
      NULL,
      1,
      0,
      0.166992,
      0,
      0.894645,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.645350,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.279998,
      3,
      1.709879,
      NULL,
      NULL,
      NULL,
      0,
      2.315169,
      4,
      NULL,
      NULL,
      0,
      0.089275,
      NULL,
      NULL,
      NULL,
      0.429435,
      4.306766,
      1.343609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.694645,
      1,
      1.781247,
      1,
      1,
      3,
      0.290789,
      2,
      1,
      NULL,
      1.039375,
      1,
      1,
      0,
      NULL,
      0.295095,
      1.512829,
      0,
      0,
      1.620774,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.853765,
      '43144',
      '',
      '',
      3.559409,
      NULL,
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


