set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9100111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-10-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '3',
      NULL,
      NULL,
      '4203324',
      12,
      3,
      NULL,
      3,
      NULL,
      1.167528,
      NULL,
      37,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      3.732116,
      NULL,
      0,
      0.313666,
      1.569952,
      1,
      1.562563,
      1,
      0.467036,
      NULL,
      5.115005,
      1.343044,
      1,
      1,
      NULL,
      1.755366,
      1.541761,
      2.466376,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.588149,
      NULL,
      NULL,
      NULL,
      1.913440,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.123040,
      1,
      0.088833,
      2.217969,
      0,
      2,
      1.206813,
      1.640251,
      NULL,
      NULL,
      1.863530,
      NULL,
      NULL,
      1,
      0.683421,
      1,
      1,
      1.833116,
      1.616488,
      0.668249,
      1,
      NULL,
      0.906452,
      0,
      1,
      NULL,
      0.621721,
      0,
      1,
      NULL,
      0,
      1.019498,
      NULL,
      0.767401,
      4.616409,
      NULL,
      1.141389,
      0,
      NULL,
      3.570525,
      NULL,
      5,
      0.816794,
      NULL,
      0.850704,
      NULL,
      NULL,
      6.575447,
      0,
      1,
      8.631450,
      NULL,
      2.305551,
      5,
      6.441417,
      9.997816,
      7,
      8.176251,
      NULL,
      3.123612,
      NULL,
      2.904844,
      0.708233,
      1.342125,
      1,
      0.998656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.967449,
      NULL,
      1,
      1,
      0,
      0,
      0.763825,
      0.539002,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.090114,
      NULL,
      NULL,
      NULL,
      1,
      4.134786,
      1.881124,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5.903013,
      8.355892,
      2.630075,
      NULL,
      0,
      0.777159,
      0,
      NULL,
      NULL,
      1.086338,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.971623,
      0.632560,
      0.601005,
      0,
      1.245370,
      0.482352,
      2.258383,
      NULL,
      NULL,
      0.829490,
      1.166231,
      0.573336,
      0,
      0,
      1.205178,
      1.767784,
      0.007508,
      1.827240,
      0,
      1.376517,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '01301',
      '',
      '',
      3,
      '42311',
      NULL,
      '',
      0.838815,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


