set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9100111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-3-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '0',
      NULL,
      NULL,
      '2233144',
      NULL,
      0,
      1.832893,
      1,
      '012100',
      0.591405,
      ' 6- 0-1986',
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      0.835855,
      3.810364,
      1.517818,
      0,
      0.990727,
      1.436336,
      4.096269,
      1.771776,
      0,
      3.115753,
      NULL,
      8.946341,
      5,
      1,
      1.566464,
      0.498189,
      0,
      NULL,
      3,
      NULL,
      4,
      0.291056,
      1,
      1.877381,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      1.525684,
      2.921613,
      1.262175,
      0,
      0,
      1.345703,
      NULL,
      0.390368,
      0,
      NULL,
      1.240366,
      1,
      1.775969,
      1.952958,
      0.348154,
      0,
      0,
      0.798933,
      NULL,
      NULL,
      0.402117,
      0.608405,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3.689364,
      NULL,
      NULL,
      2,
      2.312495,
      1.825432,
      NULL,
      1,
      2,
      0.561754,
      NULL,
      0,
      3.246795,
      NULL,
      0.333632,
      1.758759,
      1.149749,
      1,
      NULL,
      0,
      0,
      1,
      1,
      0,
      0,
      0,
      0,
      5.771246,
      2.746616,
      5,
      NULL,
      0.827898,
      NULL,
      6,
      NULL,
      0,
      6,
      NULL,
      7,
      NULL,
      7.329960,
      NULL,
      3.413870,
      5,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      5,
      0.593333,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.750270,
      2,
      0,
      NULL,
      0.698647,
      2,
      0.046763,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.051106,
      NULL,
      9.169986,
      1,
      0,
      9.080772,
      NULL,
      0,
      NULL,
      NULL,
      14.813255,
      0,
      3.792712,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.360233,
      8,
      6,
      NULL,
      NULL,
      0.651286,
      NULL,
      NULL,
      NULL,
      2.874468,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.519812,
      3,
      NULL,
      1.928051,
      1,
      1.311791,
      2.082473,
      1,
      2.395544,
      0.965386,
      1.405281,
      1.541781,
      0,
      0.989995,
      1.473908,
      1,
      1,
      0.801363,
      0.420023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '41401',
      NULL,
      NULL,
      NULL,
      '31320',
      '',
      '',
      0.801254,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


