set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9100111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-3-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      NULL,
      NULL,
      '0332403',
      6.979700,
      5,
      0.507740,
      NULL,
      '424131',
      NULL,
      NULL,
      37,
      NULL,
      NULL,
      NULL,
      3.715728,
      1,
      2,
      NULL,
      0,
      2,
      1,
      0.511451,
      2.097689,
      1,
      NULL,
      0.687703,
      NULL,
      0,
      1,
      9.425126,
      6,
      7.774285,
      1,
      1.731751,
      1,
      0.214622,
      NULL,
      0,
      NULL,
      1.520725,
      NULL,
      0,
      NULL,
      NULL,
      0.820441,
      NULL,
      NULL,
      0,
      1,
      1.321453,
      1,
      NULL,
      1,
      0.087104,
      0.897725,
      1,
      1,
      0.902056,
      1.664879,
      0,
      0.055826,
      1.942729,
      1.368625,
      0.873104,
      1.026076,
      1,
      6,
      1.486927,
      0.898240,
      0,
      NULL,
      0,
      0.881531,
      0.085071,
      NULL,
      NULL,
      0.345956,
      NULL,
      NULL,
      NULL,
      4.540100,
      NULL,
      1.361820,
      0,
      0.148874,
      NULL,
      NULL,
      1.005589,
      NULL,
      1.730416,
      1,
      1.788591,
      1.696922,
      0.012948,
      0,
      NULL,
      0.348932,
      NULL,
      NULL,
      NULL,
      1.180327,
      NULL,
      NULL,
      NULL,
      1.282944,
      6.187047,
      1,
      4,
      0.236662,
      0,
      1.293934,
      2,
      0.191906,
      4.968529,
      1,
      3,
      0,
      8,
      9.665874,
      8.663263,
      7,
      NULL,
      NULL,
      2.780922,
      0.469409,
      3,
      4,
      0.007887,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.339449,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.045666,
      3.235105,
      1,
      1,
      0,
      NULL,
      1,
      2,
      4.026492,
      0.693739,
      3,
      1.477772,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.885764,
      0.700670,
      0,
      NULL,
      3,
      0.282927,
      NULL,
      NULL,
      NULL,
      8.124581,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.421069,
      3,
      NULL,
      1,
      0,
      3.049784,
      NULL,
      3.659382,
      2.359275,
      3,
      1.967713,
      0.193503,
      1,
      NULL,
      NULL,
      1,
      1,
      1.634336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.357195,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '44101',
      '',
      '',
      1,
      '31220',
      '',
      '',
      0.848892,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


