set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9100111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-8-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '123',
      '32',
      5.636184,
      NULL,
      NULL,
      111.851537,
      0,
      3,
      NULL,
      NULL,
      1,
      NULL,
      15,
      30.056865,
      0,
      NULL,
      3.131431,
      0,
      1.287978,
      0,
      0,
      1,
      1.168192,
      0.833732,
      NULL,
      1.708383,
      6.408650,
      1,
      1.330344,
      2.537458,
      NULL,
      5.597937,
      2.171172,
      2.317558,
      7,
      7.406723,
      3.347563,
      NULL,
      NULL,
      1,
      3.844385,
      3.818724,
      0.448327,
      0.954403,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2.146316,
      1,
      1.919001,
      0.926424,
      1,
      1,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      0.251174,
      1,
      0,
      1,
      1,
      0,
      0,
      1.831779,
      NULL,
      NULL,
      1.910368,
      NULL,
      NULL,
      0,
      3.979135,
      2.722661,
      0.650236,
      2.833329,
      0.384752,
      2,
      NULL,
      NULL,
      1.471892,
      0,
      NULL,
      0.223721,
      0.400978,
      1.152287,
      NULL,
      1.032634,
      1,
      1.666019,
      NULL,
      1,
      1.647247,
      1,
      1.991628,
      1.299875,
      0,
      2,
      1.584692,
      4.371293,
      NULL,
      1,
      0.952066,
      NULL,
      1.426850,
      4,
      NULL,
      2.208664,
      1,
      4,
      4.700205,
      NULL,
      0,
      0,
      6.153813,
      7.279916,
      5.318542,
      0.222713,
      5,
      0,
      NULL,
      0.118422,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.686390,
      0,
      1,
      0,
      NULL,
      3.434615,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      9,
      1.455812,
      NULL,
      NULL,
      NULL,
      1.907105,
      1.727211,
      2.534256,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.371996,
      1.250082,
      NULL,
      5,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.217045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.960653,
      0,
      1.435173,
      0.747313,
      2,
      3,
      1.218371,
      NULL,
      0.549588,
      0.045722,
      2.592883,
      NULL,
      0.507525,
      0.654756,
      0,
      0.404902,
      NULL,
      1.385423,
      0.867139,
      0.218610,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.709177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.165808,
      '20243',
      '',
      '',
      3,
      '24422',
      '',
      '',
      1,
      '',
      '',
      '',
      3.329301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


