set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9100111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-2-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '131',
      '10',
      13.680751,
      11.554513,
      '3342010',
      NULL,
      4,
      0,
      1,
      NULL,
      1,
      ' 5- 8-1976',
      8,
      NULL,
      0.324963,
      NULL,
      NULL,
      1,
      1.072532,
      1.077714,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      4,
      1,
      0.385754,
      NULL,
      1.563909,
      0,
      0.369634,
      NULL,
      NULL,
      0,
      1.967482,
      1.558771,
      5.861919,
      0,
      1,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.144152,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.811965,
      NULL,
      0.896446,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.338490,
      1.558732,
      0.174184,
      NULL,
      3,
      NULL,
      4,
      1.994190,
      1.611725,
      0,
      3.575121,
      2.245253,
      0,
      4.735884,
      0.947950,
      1.406663,
      0,
      1.100899,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.630298,
      1.531129,
      NULL,
      5.504788,
      0.539607,
      4.866013,
      NULL,
      NULL,
      0,
      1.304758,
      1,
      2,
      0,
      5.843911,
      4.700073,
      7,
      4.724453,
      1.266641,
      6,
      2.680083,
      2.115571,
      7.808121,
      0.186901,
      0.121697,
      5.013612,
      NULL,
      0.129553,
      1,
      3,
      0.813520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.257527,
      1,
      0,
      0,
      1,
      1.337929,
      1.986895,
      0.201374,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.573115,
      NULL,
      NULL,
      3.680275,
      0,
      0.332495,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.651581,
      NULL,
      2.064413,
      2,
      0.695622,
      NULL,
      NULL,
      NULL,
      1.106984,
      0.427541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.304970,
      0,
      NULL,
      0.732988,
      0.026843,
      NULL,
      NULL,
      NULL,
      1.548273,
      3.798753,
      2.309639,
      1.514516,
      0,
      1,
      0,
      1.508916,
      0,
      0.854116,
      1,
      1.290911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '42100',
      '',
      '',
      2,
      '41233',
      '',
      '',
      1.006249,
      '',
      '',
      '',
      5.034149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


