set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9100111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-8-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '024',
      '14',
      50,
      6,
      '3442332',
      154.115231,
      NULL,
      2.463646,
      0,
      '421012',
      5,
      NULL,
      45,
      NULL,
      0.455328,
      NULL,
      1.617407,
      0,
      NULL,
      0.734752,
      1,
      0,
      0.410796,
      NULL,
      0.577643,
      1.624348,
      1.375158,
      NULL,
      0,
      1.202985,
      1.156467,
      3.790980,
      0.939913,
      NULL,
      2,
      2,
      NULL,
      1.778049,
      2.837266,
      NULL,
      3.468791,
      0.549573,
      3.874979,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.198217,
      1.499019,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.927375,
      4.823717,
      1.993963,
      5.987152,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      1.444425,
      NULL,
      NULL,
      NULL,
      2,
      1.641246,
      0,
      2.670054,
      0.296094,
      2,
      0.536140,
      NULL,
      1.132491,
      NULL,
      NULL,
      0.440995,
      2,
      1,
      0,
      NULL,
      1.656453,
      NULL,
      NULL,
      0,
      0.617856,
      0,
      1.553185,
      0,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3.395656,
      1.336259,
      1,
      NULL,
      4.442520,
      2.581384,
      1,
      3,
      0.451344,
      1,
      NULL,
      1,
      0,
      0,
      1,
      5.890777,
      3.613142,
      1,
      NULL,
      3.943258,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      0.361661,
      0,
      0.146189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.855428,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.033029,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.433921,
      0.726960,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0,
      0.889050,
      NULL,
      1,
      2,
      NULL,
      2.917144,
      NULL,
      NULL,
      NULL,
      1.550730,
      0.822222,
      0,
      1,
      0.829729,
      1,
      0.104671,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.791813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.448180,
      '33300',
      NULL,
      '',
      1,
      '31200',
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      3,
      1,
      1,
      2.035697,
      2,
      1,
      3,
      3);
commit;
end;
/


