set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9100111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-2-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '411',
      '23002122',
      7,
      47,
      '1201204',
      160.525488,
      6,
      2.451684,
      2,
      '213131',
      2,
      ' 8-19-1991',
      10,
      41,
      0,
      NULL,
      0,
      3.277413,
      1.555866,
      0,
      NULL,
      1,
      0.530227,
      NULL,
      0,
      NULL,
      7,
      1.652599,
      1,
      0.542610,
      0,
      5,
      2,
      0.855650,
      1,
      7.724213,
      1.822060,
      1.538824,
      0,
      0,
      1.725275,
      0.709160,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.700610,
      0,
      NULL,
      1,
      1.368022,
      0,
      1,
      NULL,
      3,
      NULL,
      0.014409,
      3.488912,
      1,
      3.104075,
      1.691235,
      1,
      1,
      NULL,
      5.579066,
      1.871753,
      NULL,
      3,
      0,
      0,
      NULL,
      1.092188,
      NULL,
      NULL,
      1.680327,
      NULL,
      NULL,
      NULL,
      4.856447,
      0.179377,
      NULL,
      5,
      1,
      1,
      0.389788,
      1,
      1,
      NULL,
      1,
      0,
      4.143428,
      NULL,
      0.702815,
      1,
      0,
      1.981519,
      NULL,
      0.214796,
      0.116395,
      NULL,
      NULL,
      0.734310,
      0,
      NULL,
      0,
      2,
      1,
      NULL,
      1.326127,
      0.102823,
      0.216444,
      NULL,
      1,
      0,
      NULL,
      5.162057,
      0,
      2.983328,
      7.652541,
      0,
      0,
      3.286080,
      1,
      5.943318,
      4,
      0.468294,
      1,
      1,
      3,
      0.580961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.960470,
      NULL,
      0,
      0.554756,
      NULL,
      1.280650,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.472850,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.716315,
      4,
      NULL,
      6.813578,
      2.119790,
      NULL,
      1.965157,
      NULL,
      NULL,
      NULL,
      1.931126,
      1.496740,
      1.020026,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.099448,
      NULL,
      3,
      0,
      1.044399,
      1.755733,
      NULL,
      3,
      2.455723,
      NULL,
      0.313762,
      0.188510,
      0,
      NULL,
      0,
      0,
      0.608158,
      1.952910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.260691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '02032',
      '',
      NULL,
      0,
      '20242',
      NULL,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      1,
      3.831356,
      2,
      2,
      0.015667,
      3,
      3.192410,
      0.063930);
commit;
end;
/


