set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9100111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-7-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '121',
      NULL,
      34,
      11.698281,
      '2224321',
      37,
      2,
      NULL,
      3,
      '013442',
      NULL,
      ' 2-29-1976',
      26,
      15.814123,
      1,
      NULL,
      3,
      1,
      NULL,
      0.415830,
      NULL,
      0.722308,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0,
      0.672433,
      0.117746,
      0,
      NULL,
      5.155753,
      0.263279,
      1,
      2,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      2,
      0.042947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.362640,
      1,
      0,
      0.900744,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.907536,
      0.012713,
      NULL,
      NULL,
      1,
      0.596151,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.291376,
      NULL,
      1.269612,
      1,
      1.758617,
      1.469476,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      0.130676,
      0.365230,
      1.458555,
      NULL,
      1.579016,
      NULL,
      0.567564,
      0,
      0,
      3.069349,
      NULL,
      0,
      NULL,
      4,
      3,
      0.481391,
      1.463538,
      NULL,
      NULL,
      NULL,
      NULL,
      3.128082,
      0,
      0.499800,
      5,
      1,
      0.099201,
      3,
      NULL,
      3.318820,
      5.812162,
      2,
      NULL,
      0.518775,
      0,
      8,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.182956,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      5.747398,
      2.267775,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.334662,
      3.359751,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.512339,
      7,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      4.505003,
      0.404704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.011033,
      0.555543,
      NULL,
      1.128894,
      1,
      0,
      NULL,
      NULL,
      1.665354,
      1,
      3,
      NULL,
      1.574948,
      1.264122,
      1.383600,
      NULL,
      1.916689,
      1,
      0,
      1.503652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.014110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      '',
      '',
      0.752238,
      NULL,
      '',
      '',
      1.423096,
      '',
      NULL,
      '',
      4.578700,
      5,
      NULL,
      4,
      0.292260,
      2.055116,
      2,
      1.264606,
      1);
commit;
end;
/


