set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9100111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '022',
      '14202421',
      33.989007,
      7,
      '4233200',
      71,
      6,
      2,
      3,
      '244213',
      NULL,
      ' 3- 2-1981',
      32.006382,
      2.108706,
      1.822926,
      NULL,
      0.774459,
      NULL,
      3,
      1,
      1,
      3,
      1,
      1,
      NULL,
      1.245523,
      NULL,
      1,
      0.479908,
      1.255656,
      1,
      2.511633,
      2,
      NULL,
      1,
      NULL,
      1.514066,
      1.890671,
      6,
      0,
      2,
      2,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.196581,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.955055,
      NULL,
      0.840102,
      5,
      1,
      NULL,
      0.658176,
      0.918912,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0,
      3.737258,
      2.547985,
      5.197407,
      0.779525,
      1,
      0,
      0,
      0.857886,
      NULL,
      5,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1.415291,
      3,
      2.049334,
      1.885224,
      NULL,
      5.408268,
      3,
      0.368413,
      0.499683,
      0,
      NULL,
      1.709335,
      3,
      3.932570,
      NULL,
      0.556454,
      NULL,
      1,
      NULL,
      1.300282,
      5.641537,
      NULL,
      0,
      4,
      2.069647,
      1.726306,
      1.559896,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.408316,
      1.794661,
      1,
      NULL,
      NULL,
      1.348215,
      NULL,
      0.780823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      0.025251,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.895581,
      3.928779,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.202386,
      1,
      3,
      1,
      1,
      2,
      0.873277,
      2,
      0.310484,
      1,
      2.624971,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      1.050768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.465549,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '32301',
      '',
      NULL,
      3.650536,
      '10041',
      '',
      '',
      1,
      '',
      NULL,
      NULL,
      4,
      3,
      NULL,
      NULL,
      0.385739,
      NULL,
      0.433087,
      2,
      3.926213);
commit;
end;
/


