set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9100111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-9-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '003',
      '10000244',
      71,
      48.119911,
      '2033442',
      189.418236,
      2,
      2,
      1,
      '212342',
      6,
      ' 0-21-1986',
      22.947510,
      NULL,
      1.849448,
      NULL,
      1.024365,
      0.773636,
      2,
      0.858938,
      0.667478,
      1.108825,
      1,
      NULL,
      2,
      1,
      1.404373,
      1,
      0.666142,
      0,
      1,
      2.616601,
      2.303015,
      0,
      3,
      0.159118,
      NULL,
      1.857228,
      6,
      0,
      NULL,
      2.825903,
      NULL,
      0.089143,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.718356,
      0.115171,
      1.794474,
      1.090690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.989361,
      NULL,
      0,
      NULL,
      0.308470,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.266431,
      NULL,
      0,
      NULL,
      NULL,
      1.509616,
      1.016924,
      1.007320,
      1.293281,
      1.821845,
      0.880976,
      1.543121,
      0.207742,
      1,
      1,
      0,
      NULL,
      NULL,
      0.227943,
      0,
      1,
      0,
      0.520499,
      NULL,
      1.356615,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4,
      0.231435,
      2.317822,
      NULL,
      0,
      2.293983,
      2,
      NULL,
      2,
      3,
      NULL,
      3.384576,
      1,
      NULL,
      3.348106,
      1.027776,
      0.319272,
      3,
      1.521120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.749708,
      1,
      1,
      1.366235,
      NULL,
      NULL,
      1.500682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.397435,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.380912,
      3.630444,
      NULL,
      5,
      2,
      1.358789,
      NULL,
      NULL,
      NULL,
      1,
      2.750435,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0,
      1.828099,
      0.445820,
      1,
      2.492327,
      1,
      1,
      1.573691,
      1.644187,
      0,
      0,
      1.226125,
      0.588003,
      0.840277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.292099,
      '32243',
      '',
      '',
      1.158695,
      '02130',
      '',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2.670575,
      2,
      0,
      2.029704,
      NULL);
commit;
end;
/


