set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9100111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-2-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '142',
      '00332023',
      NULL,
      19,
      NULL,
      NULL,
      3,
      0.014782,
      0,
      '244140',
      NULL,
      '11-26-1998',
      44.342659,
      52.162167,
      0.518184,
      NULL,
      3,
      0,
      1.373080,
      1.653192,
      NULL,
      NULL,
      1,
      1.437640,
      0,
      1.974886,
      5.161970,
      0.462063,
      0.232249,
      1,
      0,
      4.948299,
      1,
      1.411510,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0,
      3.885422,
      2.538151,
      0,
      0,
      NULL,
      NULL,
      1.522939,
      NULL,
      NULL,
      0.389793,
      1.753723,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.939669,
      5.953225,
      0,
      0,
      1.064743,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3.293059,
      0.872685,
      0.628370,
      2.201392,
      4.661333,
      1,
      1.763704,
      1.327417,
      NULL,
      0,
      NULL,
      1.216353,
      0.512507,
      0,
      1,
      1.379374,
      1.173550,
      0,
      NULL,
      0,
      1.353209,
      0.375379,
      0.606386,
      1.941247,
      NULL,
      1,
      1,
      3,
      0.699398,
      4.859270,
      0,
      0.308709,
      1,
      0.495143,
      NULL,
      2.377697,
      2.027501,
      4.939832,
      5,
      5.814631,
      0,
      NULL,
      0.788037,
      5,
      2,
      2,
      2,
      1,
      NULL,
      0.216482,
      1.872724,
      1.161999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.195499,
      0,
      1,
      NULL,
      0.186650,
      1.204437,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.635426,
      NULL,
      NULL,
      NULL,
      NULL,
      1.330223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.963571,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.088679,
      NULL,
      5.908094,
      1.941168,
      NULL,
      1.774499,
      NULL,
      NULL,
      NULL,
      1.366126,
      0.258499,
      0.598238,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.673269,
      NULL,
      NULL,
      0.240242,
      0,
      3.050780,
      NULL,
      0.923458,
      0.279618,
      2,
      0.284371,
      0,
      1,
      NULL,
      0.558598,
      0,
      1.039610,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.048960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '24324',
      NULL,
      NULL,
      3,
      '23442',
      '',
      NULL,
      1.226695,
      '',
      '',
      '',
      3,
      3.687232,
      0.470911,
      3,
      1,
      1,
      1,
      2.959422,
      5);
commit;
end;
/


