set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9100111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '00334122',
      75,
      NULL,
      NULL,
      55,
      1,
      3.561624,
      2,
      '424324',
      5,
      ' 4-28-1991',
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      1.273775,
      3.035395,
      1.518931,
      1,
      0.325982,
      1,
      NULL,
      7,
      0,
      NULL,
      0,
      1.980934,
      7,
      4,
      1,
      NULL,
      0.780765,
      0,
      1.911051,
      1,
      NULL,
      3,
      3,
      0,
      1.667142,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.362649,
      0,
      0.132718,
      1.161203,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.496011,
      NULL,
      4.139003,
      1,
      1,
      1,
      0.352643,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.243750,
      0.266579,
      1,
      1.631707,
      0.586977,
      5.382346,
      0.731796,
      NULL,
      1.465302,
      0.088105,
      0,
      1,
      2,
      NULL,
      1,
      1.513129,
      1.501536,
      0,
      NULL,
      1,
      0.610394,
      1,
      1,
      1.832204,
      1.805196,
      1.904545,
      0.806113,
      3,
      NULL,
      1,
      0.980727,
      1,
      NULL,
      0.797708,
      0.998886,
      1,
      1.240383,
      NULL,
      NULL,
      0,
      2.224288,
      3.497323,
      4,
      0,
      0,
      7.524669,
      5,
      0.311905,
      1.530659,
      0,
      1.696628,
      1.383819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.865493,
      0,
      0,
      1.642926,
      3.485356,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.323448,
      0,
      1.562299,
      1.709093,
      3.991867,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.887429,
      4.324919,
      6.737710,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.373667,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.063252,
      3.895841,
      3.020579,
      3,
      1,
      0.122823,
      1,
      1.557032,
      1,
      3.416281,
      0.249878,
      1.226439,
      0.102556,
      1.346400,
      0.584697,
      0,
      NULL,
      NULL,
      0.187393,
      1.617914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.841877,
      '34141',
      '',
      '',
      3.548462,
      '11120',
      '',
      '',
      0.377234,
      '',
      '',
      '',
      NULL,
      5,
      1.668900,
      NULL,
      0,
      2,
      2.558441,
      3,
      2.455393);
commit;
end;
/


