set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9100111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-8-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '30404420',
      NULL,
      60,
      NULL,
      288.968374,
      0,
      1.383376,
      2,
      NULL,
      3,
      ' 8- 0-1991',
      43,
      33.850046,
      0,
      NULL,
      3.187920,
      NULL,
      1,
      0,
      0.531996,
      2.005757,
      0.450279,
      0.463688,
      1.402395,
      NULL,
      3.559843,
      NULL,
      1.749726,
      0.429723,
      0,
      0.493616,
      4,
      1.201575,
      0.026050,
      4.798362,
      0.336073,
      1,
      0.073742,
      NULL,
      1.553345,
      3,
      2.125408,
      1.193350,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0.841411,
      0.010597,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      4,
      NULL,
      5.893637,
      0,
      1,
      1.284686,
      1.153946,
      NULL,
      NULL,
      0.071928,
      NULL,
      NULL,
      1.776502,
      2,
      1,
      0,
      3,
      NULL,
      2.164216,
      1.061474,
      0.304927,
      1,
      0.138502,
      1.652926,
      NULL,
      2.864727,
      NULL,
      0.658427,
      1.095568,
      NULL,
      1.639439,
      NULL,
      1.772459,
      0,
      0.160330,
      1,
      1.447741,
      3,
      NULL,
      0,
      5.664254,
      0,
      NULL,
      0,
      1,
      1.976200,
      1.319940,
      1.705934,
      3.678929,
      4,
      3.939099,
      2,
      3,
      5.142886,
      1.099107,
      2.346918,
      NULL,
      4.142487,
      9.547572,
      NULL,
      3.890520,
      NULL,
      0.495933,
      1,
      1.282100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.197669,
      1,
      1,
      1,
      4,
      0,
      0.104875,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      4,
      1,
      NULL,
      0.941376,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.366267,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      5,
      5.930312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.416741,
      0.421908,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.187475,
      0,
      0.788330,
      1,
      NULL,
      1,
      1.460346,
      0.338055,
      1,
      NULL,
      1.631524,
      1,
      0.758478,
      0.704068,
      1.785087,
      0,
      NULL,
      1.344702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.036598,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.982414,
      NULL,
      NULL,
      '',
      0.507010,
      '20424',
      '',
      '',
      0,
      '',
      '',
      NULL,
      2,
      1.947658,
      NULL,
      2,
      1,
      NULL,
      NULL,
      3.476669,
      NULL);
commit;
end;
/


