set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9100111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-2-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4330',
      '10020323',
      64.249033,
      5.611329,
      '4424041',
      NULL,
      4,
      0.127288,
      3,
      '304343',
      2,
      NULL,
      NULL,
      56.104508,
      0.549728,
      NULL,
      2,
      NULL,
      3.531730,
      1.898225,
      1,
      2,
      NULL,
      0,
      1.489743,
      1.346960,
      2,
      0.816948,
      0.417226,
      0,
      0,
      3,
      0,
      0.836709,
      1,
      0.678999,
      0,
      1,
      4,
      0,
      3,
      3.741876,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      1.302596,
      NULL,
      1,
      0,
      0.793708,
      1,
      NULL,
      NULL,
      0.955590,
      NULL,
      NULL,
      1,
      0,
      0,
      1.596169,
      1,
      1.061216,
      0.843133,
      0.319631,
      0.188964,
      NULL,
      0,
      1,
      0,
      3,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.153403,
      NULL,
      1,
      NULL,
      NULL,
      5,
      NULL,
      1.418115,
      0.814323,
      0,
      0,
      1.738161,
      NULL,
      0.796950,
      2.804603,
      1,
      0.141558,
      0,
      0,
      5.220382,
      1.592000,
      5,
      2,
      3,
      5.916319,
      1,
      0.481942,
      4.549342,
      3,
      NULL,
      0.443426,
      9,
      1.044311,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0.592542,
      5,
      0.897018,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.016971,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.489052,
      0,
      0.806685,
      NULL,
      NULL,
      NULL,
      3.251995,
      1,
      3.269502,
      1,
      2.560798,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.063285,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.163845,
      3.892570,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.923962,
      1,
      1,
      1,
      0.192533,
      1,
      0,
      0.276743,
      NULL,
      1.317524,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '42442',
      NULL,
      NULL,
      3.919683,
      '32120',
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      2,
      3,
      3,
      2,
      0.138538,
      1,
      1.536446,
      2.860128);
commit;
end;
/


