set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9100111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-2-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1423',
      '1',
      9,
      NULL,
      NULL,
      321.130937,
      5,
      3,
      2,
      '130141',
      1.459934,
      NULL,
      NULL,
      17,
      1,
      NULL,
      0.055177,
      0,
      1,
      0,
      NULL,
      3,
      0,
      1,
      1.146853,
      1,
      5,
      0.283385,
      0,
      NULL,
      0,
      0,
      4,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      3.929892,
      3,
      0.319365,
      1.651684,
      NULL,
      NULL,
      1.851848,
      NULL,
      NULL,
      1.541997,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.722998,
      2.764199,
      NULL,
      1.569230,
      0,
      1,
      1.890092,
      1.727473,
      NULL,
      NULL,
      0.394085,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.305472,
      1.359644,
      5,
      5,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      5,
      NULL,
      NULL,
      0,
      1.513363,
      0,
      NULL,
      NULL,
      1,
      1.883164,
      NULL,
      0,
      1.412350,
      NULL,
      NULL,
      0.058291,
      1,
      0.859139,
      0,
      0.618749,
      NULL,
      1.797418,
      1,
      1,
      1.297256,
      2.195366,
      NULL,
      4,
      5,
      4,
      NULL,
      5.192053,
      5.689813,
      7,
      1,
      3.782436,
      1,
      1.602016,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.818969,
      NULL,
      1,
      0.356321,
      0.107730,
      1.701674,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.636345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.316307,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.747097,
      2,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.332256,
      0,
      NULL,
      0,
      1,
      2,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      0,
      0.230868,
      1.238485,
      0.510985,
      NULL,
      0.111177,
      0.675774,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.035009,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.354112,
      '40403',
      '',
      '',
      0,
      NULL,
      '',
      '',
      0.972879,
      '',
      '',
      NULL,
      NULL,
      1,
      3,
      2.592381,
      1,
      2,
      0,
      1.613619,
      0);
commit;
end;
/


