set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      '0432221',
      NULL,
      3,
      3,
      2,
      '411020',
      1,
      NULL,
      16,
      NULL,
      0,
      NULL,
      NULL,
      1.223652,
      2.503423,
      NULL,
      1,
      1,
      1.917235,
      0,
      NULL,
      1.571772,
      1.793355,
      0,
      NULL,
      NULL,
      3.875927,
      0.852527,
      NULL,
      NULL,
      1.754528,
      NULL,
      0.513393,
      0,
      5,
      1,
      2,
      NULL,
      NULL,
      1.723985,
      NULL,
      NULL,
      1.484490,
      NULL,
      NULL,
      0,
      1.842135,
      0,
      NULL,
      1,
      0.064296,
      3.988930,
      0.009208,
      2,
      0,
      2.819501,
      NULL,
      NULL,
      0,
      2.863274,
      NULL,
      0.758533,
      1,
      1.191435,
      1,
      1,
      1.064569,
      NULL,
      0,
      0,
      5.840687,
      1.019604,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.495324,
      1,
      0,
      0.072766,
      0,
      1.549108,
      NULL,
      0,
      2,
      NULL,
      1,
      NULL,
      1.874146,
      5.572079,
      NULL,
      0.237545,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      1.515922,
      4.249453,
      NULL,
      4,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      4,
      5.000309,
      NULL,
      NULL,
      4.300610,
      2.696270,
      1,
      2,
      NULL,
      1,
      2,
      5,
      NULL,
      2,
      4.068350,
      0.332220,
      0,
      0,
      8,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.427101,
      NULL,
      NULL,
      0,
      0.074822,
      0.250060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.014626,
      1.248404,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.009487,
      5,
      1.702546,
      NULL,
      2,
      1.486114,
      NULL,
      NULL,
      0,
      0.635289,
      0.693790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.864279,
      3.040428,
      1,
      0,
      1.884425,
      2.063062,
      1.925840,
      0.944189,
      NULL,
      2,
      3,
      0.756893,
      0.843811,
      0.648396,
      0.810538,
      0.523296,
      0.949896,
      NULL,
      NULL,
      1.273302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      1.706838,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


