set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      NULL,
      NULL,
      '2230323',
      13,
      0,
      0,
      2,
      '042324',
      3.455212,
      ' 8-14-1993',
      17.141172,
      NULL,
      1.671544,
      NULL,
      NULL,
      0.102856,
      NULL,
      0.370377,
      1.286369,
      0.107645,
      0.483694,
      NULL,
      1.872268,
      NULL,
      0,
      0.829814,
      3.845384,
      4,
      2,
      3.885253,
      NULL,
      NULL,
      0.417681,
      0.680663,
      NULL,
      1.657296,
      NULL,
      NULL,
      3.140877,
      NULL,
      2.849940,
      1.789463,
      NULL,
      NULL,
      0.455942,
      NULL,
      NULL,
      4,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2,
      0.668778,
      0.751501,
      2,
      1,
      NULL,
      2.355888,
      1,
      NULL,
      2,
      1.145450,
      NULL,
      1.450063,
      NULL,
      1.925396,
      0.371144,
      4.678050,
      1,
      0,
      5,
      0.893335,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.486222,
      0.495297,
      NULL,
      NULL,
      0.126755,
      1.709711,
      2,
      0,
      0,
      0.541017,
      1.218392,
      1.252480,
      0,
      0,
      1.116350,
      1,
      NULL,
      1,
      0,
      NULL,
      0.885177,
      1,
      3,
      0,
      0.432072,
      0,
      1,
      0,
      1,
      0.916120,
      2.727111,
      0,
      0.628934,
      5.955303,
      NULL,
      0,
      1.007458,
      4.155993,
      7.796778,
      NULL,
      0,
      0,
      0,
      1.453261,
      6.247308,
      1.469181,
      NULL,
      5,
      1,
      1,
      1,
      4.536615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.813828,
      1.174061,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.938527,
      NULL,
      3,
      3.024585,
      1.374214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2.051615,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.131316,
      NULL,
      2,
      3.008825,
      NULL,
      0,
      0.923451,
      3,
      1,
      NULL,
      7.691242,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.484363,
      1.166268,
      0.065533,
      2.333644,
      0,
      NULL,
      3,
      1,
      1.077495,
      1,
      1,
      1.513217,
      NULL,
      1,
      NULL,
      1,
      1.381977,
      0,
      0.698094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '34320',
      '',
      '',
      1,
      NULL,
      '',
      NULL,
      1.768128,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


