set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-12-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.199166,
      0,
      NULL,
      2.344201,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      10.172393,
      0,
      3.933970,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      1,
      1.931943,
      1.378291,
      1.653488,
      NULL,
      0.143925,
      0,
      0,
      1,
      NULL,
      1,
      0.340564,
      1,
      1.173679,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.843270,
      1.548420,
      0.341798,
      2.386265,
      0,
      0.043265,
      NULL,
      3,
      0,
      1,
      1.314282,
      1,
      0.306825,
      NULL,
      0,
      1,
      1.781701,
      1.901895,
      NULL,
      0.080832,
      0.361784,
      0,
      5.149711,
      1,
      1,
      1.259475,
      0,
      NULL,
      NULL,
      1.613562,
      NULL,
      NULL,
      0,
      0.412078,
      1.221314,
      0,
      0.591715,
      0.200725,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      0.353343,
      2,
      NULL,
      1,
      0,
      1.883934,
      1,
      NULL,
      1,
      NULL,
      0.847115,
      1.782491,
      0,
      0,
      3.184848,
      0,
      1,
      1,
      1.081435,
      1,
      2,
      0.888352,
      2,
      1.046119,
      0.179986,
      NULL,
      NULL,
      1.851353,
      2,
      3.811253,
      NULL,
      0,
      4,
      0,
      0,
      4.087256,
      1,
      NULL,
      NULL,
      6.705570,
      0.282822,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.351577,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.983232,
      NULL,
      NULL,
      NULL,
      NULL,
      1.099679,
      1,
      NULL,
      1,
      0.928932,
      NULL,
      0,
      0.204824,
      3.095123,
      2.683102,
      NULL,
      1.718974,
      NULL,
      0,
      NULL,
      1.392079,
      NULL,
      0,
      NULL,
      0.250755,
      NULL,
      NULL,
      1.612852,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.610570,
      1.378530,
      1,
      1.504588,
      1,
      3,
      0.000408,
      1,
      NULL,
      0.549568,
      NULL,
      1.385597,
      1.508773,
      1.398961,
      1,
      NULL,
      0.486381,
      1.338657,
      0,
      1.594683,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.760691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      '',
      '',
      0.421366,
      '',
      '',
      '',
      1.733683,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


