set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-6-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      NULL,
      NULL,
      NULL,
      145.181270,
      4,
      3,
      0,
      '311033',
      2.787549,
      ' 8-22-1979',
      13.196441,
      NULL,
      0.444810,
      NULL,
      8.081649,
      0,
      1.264662,
      NULL,
      1.631079,
      NULL,
      0,
      1.622000,
      0,
      1,
      NULL,
      1.488264,
      1,
      0.172803,
      NULL,
      0,
      1,
      NULL,
      0,
      0.142210,
      0,
      1.561423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.348894,
      0.122346,
      NULL,
      1,
      0.762980,
      1,
      0,
      NULL,
      0.937009,
      0.474415,
      1,
      1.451178,
      2,
      0.844878,
      0.914880,
      1.890775,
      0.148581,
      3,
      NULL,
      1.164814,
      NULL,
      1.514678,
      1,
      2,
      0,
      1,
      NULL,
      NULL,
      1.204792,
      NULL,
      NULL,
      NULL,
      NULL,
      1.648610,
      0,
      1,
      NULL,
      1.282368,
      0.646081,
      0,
      0,
      1.844762,
      0,
      0.587362,
      1.397138,
      1.928533,
      0.334128,
      0,
      NULL,
      1.995361,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.738044,
      1,
      5.821744,
      0,
      0,
      1.191663,
      NULL,
      2,
      0.145467,
      0,
      2.341880,
      4,
      NULL,
      5,
      2,
      3,
      2.020921,
      1.504936,
      0.620461,
      NULL,
      NULL,
      1.776290,
      0.328834,
      NULL,
      NULL,
      3.164864,
      0.134466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.563669,
      0,
      1,
      NULL,
      NULL,
      0,
      1.567308,
      1.962567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4.769555,
      0,
      2,
      1,
      0.941170,
      1.826190,
      0.377962,
      NULL,
      0.115723,
      NULL,
      NULL,
      NULL,
      NULL,
      0.126442,
      2.148764,
      NULL,
      3.290818,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2.124809,
      1.772320,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.903748,
      1.680065,
      1.869300,
      1,
      0.485649,
      0.840814,
      0.497029,
      2.147914,
      0,
      0.840121,
      NULL,
      0.997566,
      0.292043,
      1,
      0,
      1.748575,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.844512,
      '24001',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.663576,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


