set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-12-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '231',
      '40',
      25.276629,
      NULL,
      '0122101',
      2.906685,
      1,
      NULL,
      NULL,
      '314133',
      0,
      ' 6-26-1975',
      26,
      8.607213,
      0,
      NULL,
      19.057904,
      0.558549,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1.580179,
      NULL,
      0,
      1.398252,
      0.645283,
      NULL,
      NULL,
      0.641268,
      0,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      1.381467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.817210,
      0.512212,
      0,
      0.442225,
      3,
      0,
      1.088078,
      NULL,
      NULL,
      1.888794,
      0,
      2.698532,
      2,
      0.748052,
      3,
      1,
      3.496248,
      1,
      1.049754,
      NULL,
      5.736079,
      1,
      0,
      0.511167,
      1.029117,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.863357,
      0.983309,
      1.085112,
      1.348574,
      NULL,
      NULL,
      5.854645,
      NULL,
      0.267705,
      1,
      0,
      1,
      NULL,
      3.126144,
      0,
      0.935054,
      1,
      0.082242,
      0,
      NULL,
      0,
      NULL,
      1.016089,
      NULL,
      2.546368,
      1,
      2,
      0,
      4.515746,
      0,
      NULL,
      NULL,
      4,
      0,
      5,
      NULL,
      0.961095,
      0.426298,
      5.538037,
      5.192934,
      NULL,
      NULL,
      3,
      2.107213,
      2,
      2.044841,
      0,
      0,
      1,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.430945,
      0,
      0,
      0,
      1,
      NULL,
      0.258511,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      1,
      1,
      1.965292,
      0.424097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.260227,
      0,
      0.636583,
      5.590832,
      0.023621,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.161651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.328310,
      NULL,
      1.423119,
      1.673867,
      3.876288,
      2.498233,
      1,
      1.198813,
      1.122915,
      2.424733,
      0,
      1,
      0,
      0.587288,
      1,
      0,
      1.158852,
      1,
      1.128535,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.398904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '42131',
      '',
      '',
      0.437104,
      '',
      '',
      NULL,
      0.314899,
      '',
      NULL,
      '',
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


