set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-5-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '412',
      NULL,
      NULL,
      6,
      '4444424',
      NULL,
      3,
      2.359758,
      2,
      '422030',
      1.467756,
      '10-12-2001',
      34.674661,
      41,
      1,
      NULL,
      15.724292,
      1.161007,
      2,
      0,
      1.376246,
      NULL,
      1.573494,
      0,
      0.813975,
      0.476020,
      0.580522,
      0,
      1.127136,
      NULL,
      0.043274,
      0,
      5.679704,
      NULL,
      1.883694,
      1,
      0,
      0.845874,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.320320,
      NULL,
      1,
      2,
      NULL,
      1,
      3.189702,
      3,
      0,
      1.667405,
      1,
      1.291495,
      0,
      2.756012,
      NULL,
      1,
      2,
      1.194801,
      1.111566,
      0,
      0,
      0,
      1,
      1,
      1,
      1.002285,
      1.544245,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.974585,
      1.024580,
      1.737648,
      0,
      0,
      0,
      1.004965,
      1.993312,
      0.119899,
      0.481647,
      0,
      0.063013,
      0.954570,
      1.365326,
      0.974206,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1,
      1.609353,
      NULL,
      0.989889,
      1.070411,
      NULL,
      0,
      5.321787,
      0.252662,
      3,
      1,
      3,
      1.016483,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      7,
      NULL,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.119727,
      0,
      0,
      1.965114,
      0.209426,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.685199,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.150219,
      0.721150,
      1,
      2,
      1,
      3,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0.485575,
      0.443699,
      0,
      1.213207,
      1.132191,
      NULL,
      NULL,
      0.548880,
      3.248368,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.544471,
      0.683870,
      1.877781,
      1.495757,
      2,
      NULL,
      NULL,
      3,
      NULL,
      1.051926,
      1,
      1.458395,
      0,
      0,
      0,
      NULL,
      0.295651,
      1.316627,
      0.362393,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '20044',
      '',
      NULL,
      1.297368,
      '',
      NULL,
      '',
      1.950993,
      '',
      '',
      '',
      0.345451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


