set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-6-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '132',
      '00',
      1,
      17.322745,
      '0300132',
      59,
      4,
      2.198779,
      3,
      '124041',
      3.933994,
      '11- 9-1979',
      NULL,
      20.140269,
      0.092549,
      NULL,
      12.352972,
      1,
      1,
      1,
      0.324782,
      2,
      0,
      NULL,
      0.158826,
      0.778294,
      0,
      NULL,
      3,
      NULL,
      1,
      0.409523,
      4.600528,
      NULL,
      1.758337,
      0,
      2,
      0.629307,
      NULL,
      NULL,
      3.354848,
      0.453422,
      0.804125,
      0.013408,
      NULL,
      NULL,
      1.903687,
      NULL,
      NULL,
      2.380886,
      1.309585,
      0.761333,
      0,
      0.894155,
      0,
      1,
      2,
      1.061749,
      2,
      NULL,
      1,
      0.365346,
      NULL,
      1.017171,
      0.924932,
      3,
      2,
      0.867301,
      NULL,
      1.935941,
      1.395001,
      0.455869,
      1,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.719970,
      1.235695,
      NULL,
      0,
      0,
      3.982761,
      0.367890,
      NULL,
      0.129000,
      1,
      1,
      1.392135,
      3.207927,
      1.982991,
      1,
      1.578641,
      0.472346,
      1,
      NULL,
      0,
      NULL,
      1.617668,
      2,
      1,
      1,
      5.802524,
      1,
      0.924324,
      1,
      1.650746,
      1.371410,
      NULL,
      2.658761,
      0.277271,
      1,
      NULL,
      5,
      0,
      3.073068,
      1,
      1.946596,
      1.918122,
      0,
      1,
      NULL,
      0.392476,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1.029393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.815089,
      NULL,
      1,
      0.600994,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.027754,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.453617,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.072165,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.416048,
      2,
      0.665215,
      2.749782,
      1.333037,
      0.446647,
      2,
      1.757330,
      3.517043,
      1.264196,
      0,
      0,
      0.809429,
      1.649934,
      NULL,
      1.767312,
      NULL,
      0.972988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '23144',
      '',
      '',
      1,
      '',
      '',
      NULL,
      1,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      3,
      NULL,
      0.206666,
      0,
      1,
      1.370066,
      2.708999);
commit;
end;
/


