set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-11-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '202',
      '34414313',
      9.770249,
      2,
      '0441331',
      211,
      4,
      NULL,
      2,
      '121200',
      5.373400,
      ' 6-12-1986',
      NULL,
      14,
      0.248758,
      NULL,
      14,
      0,
      3.264065,
      NULL,
      1.633785,
      3.100168,
      0,
      1.903160,
      NULL,
      0.425057,
      NULL,
      NULL,
      0,
      0.545780,
      2.763975,
      1,
      NULL,
      0,
      0.325203,
      1,
      0.879085,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0.966216,
      0.518732,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.211501,
      0.019482,
      0.157623,
      0.374940,
      0.050019,
      0,
      1.532853,
      3,
      NULL,
      3.920256,
      0.458103,
      0,
      1,
      1,
      3.492153,
      0,
      1.920914,
      1.578644,
      NULL,
      NULL,
      1.532510,
      1,
      2,
      0,
      0,
      1.594260,
      0.720582,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0.775767,
      0,
      1.146231,
      0.817123,
      5.440263,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      4,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.960680,
      1.543915,
      0,
      NULL,
      0.009972,
      0,
      4,
      NULL,
      1,
      5,
      0.046825,
      1,
      0,
      1,
      1.117932,
      3,
      NULL,
      3,
      1,
      0,
      0.164147,
      NULL,
      0,
      1.779270,
      6.371038,
      2.999600,
      NULL,
      NULL,
      NULL,
      0,
      1.446995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.788686,
      0,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.142949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.180930,
      0.924160,
      0.982158,
      NULL,
      2,
      5,
      1,
      NULL,
      NULL,
      1,
      3.551581,
      0.892966,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.991171,
      NULL,
      0.183876,
      NULL,
      3,
      NULL,
      NULL,
      3,
      0,
      3,
      NULL,
      1,
      0.605155,
      1.524441,
      0.268837,
      1,
      1,
      1.838116,
      1,
      1.840295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.819059,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      3.800444,
      2,
      4,
      NULL,
      NULL,
      1.136818,
      1.721951,
      NULL,
      2);
commit;
end;
/


