set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-4-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '112',
      '30041300',
      38.360862,
      14,
      '0112000',
      170.658939,
      NULL,
      0,
      0,
      '412140',
      NULL,
      NULL,
      10.261099,
      27.635296,
      0,
      NULL,
      7,
      0,
      2,
      1.088529,
      0.916401,
      1.275777,
      0,
      0.796921,
      NULL,
      1,
      0.972394,
      0,
      1,
      1.996316,
      1,
      0,
      5,
      1.365052,
      1.105369,
      0,
      NULL,
      NULL,
      0.384428,
      1,
      2,
      0.287580,
      1.745454,
      0.123800,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.231966,
      0,
      NULL,
      NULL,
      NULL,
      1.024108,
      1.326478,
      0,
      1.918693,
      0.962266,
      1.211343,
      1.290769,
      0.845476,
      2,
      NULL,
      2,
      1,
      1,
      NULL,
      0.750918,
      1,
      2.602690,
      1,
      1,
      1.408677,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.374349,
      1.744933,
      0,
      0,
      NULL,
      0,
      5.853652,
      1.921302,
      0.197221,
      0,
      1,
      0,
      NULL,
      1.677901,
      1.509886,
      1.965020,
      0.793019,
      NULL,
      1,
      NULL,
      1.985309,
      1.061081,
      0,
      0,
      2.220610,
      NULL,
      5,
      0.781766,
      5,
      1.716247,
      1,
      1.887601,
      0,
      1,
      4,
      4.722734,
      1,
      1.402274,
      2.612231,
      0,
      0,
      1,
      1.797127,
      0.224412,
      1.716930,
      2.161016,
      0,
      2,
      1.531365,
      NULL,
      NULL,
      8.293365,
      0.420173,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.852162,
      1,
      1,
      0,
      0,
      1.940501,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.897695,
      2.104115,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.152626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.436490,
      0,
      1,
      1.447477,
      NULL,
      NULL,
      2.885003,
      1,
      NULL,
      NULL,
      0.488510,
      1.927001,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      3.613809,
      2.894480,
      NULL,
      1.849616,
      0.583316,
      1.013583,
      0,
      1.184127,
      NULL,
      1,
      NULL,
      1.332025,
      0.044672,
      1,
      NULL,
      0.403624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '',
      '',
      0.130006,
      '',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      2.975003,
      NULL,
      0,
      4,
      0,
      3.460953,
      0,
      3,
      3.571371);
commit;
end;
/


