set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-10-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '31102320',
      15,
      29,
      '0332301',
      247.506057,
      0,
      2.744915,
      0,
      '213343',
      NULL,
      ' 8-12-1977',
      NULL,
      47,
      0,
      NULL,
      6,
      0.430614,
      3,
      1,
      1.429960,
      NULL,
      0,
      0,
      0,
      0,
      1,
      NULL,
      1.773362,
      1,
      1.475229,
      1,
      NULL,
      0.809043,
      0.436373,
      1,
      NULL,
      0,
      4,
      1,
      3.964549,
      0,
      0,
      0.455629,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.555522,
      0,
      1,
      1.735928,
      0.846348,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1.893855,
      NULL,
      NULL,
      3.021496,
      0.219520,
      0.136532,
      0.761402,
      5,
      1,
      1,
      0.255626,
      NULL,
      NULL,
      NULL,
      1.418228,
      NULL,
      NULL,
      0.596966,
      NULL,
      0.613441,
      1,
      0.863722,
      0,
      1.892451,
      0,
      1.863097,
      0,
      1,
      1.633221,
      1,
      3,
      0.754800,
      0,
      1.848999,
      0.996882,
      1.154433,
      NULL,
      0,
      2,
      0.437010,
      1,
      0.743718,
      NULL,
      2,
      NULL,
      0,
      0,
      0,
      0,
      0.238477,
      4,
      5.037901,
      NULL,
      1.099150,
      5.394817,
      1,
      3.498866,
      1,
      NULL,
      4,
      0.214216,
      NULL,
      0.306875,
      0,
      2,
      1,
      NULL,
      NULL,
      4.457739,
      0.002443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.081970,
      0.477554,
      0,
      1,
      1.731317,
      1.674034,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.343998,
      NULL,
      NULL,
      2.504392,
      3,
      1.897346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.200844,
      2,
      0.145518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      3.780414,
      0,
      NULL,
      NULL,
      1,
      2.693667,
      0.253943,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.915407,
      2.121600,
      2,
      0,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.338854,
      0,
      0,
      0.917612,
      1.884546,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.712708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '31234',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      NULL,
      3.267731,
      NULL,
      0.080539,
      2.361277,
      0,
      0,
      1.491394);
commit;
end;
/


