set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-5-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '433',
      '02302104',
      NULL,
      17.626804,
      NULL,
      188,
      3,
      NULL,
      NULL,
      '131311',
      6.021854,
      ' 2- 8-1996',
      NULL,
      3,
      0,
      NULL,
      12.101152,
      NULL,
      2.368175,
      0.184849,
      0.730504,
      1.984322,
      1,
      NULL,
      NULL,
      0,
      4.647613,
      NULL,
      0,
      1,
      1.339415,
      NULL,
      4.209518,
      0,
      NULL,
      NULL,
      0.221453,
      1.466900,
      2,
      1,
      0.996593,
      1,
      3,
      0,
      NULL,
      NULL,
      0.229976,
      NULL,
      NULL,
      2,
      NULL,
      1.298902,
      0,
      NULL,
      1.126884,
      NULL,
      3,
      1.986474,
      1.446129,
      0,
      NULL,
      0,
      1,
      0.016116,
      0,
      0.171582,
      0,
      NULL,
      1,
      1,
      0.968588,
      2.529596,
      0,
      1,
      1.246633,
      0.036206,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      5.724437,
      1.027059,
      1,
      1.931645,
      0,
      NULL,
      5,
      1.039239,
      2.384403,
      0.368960,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      5.782086,
      0,
      1,
      3.028586,
      NULL,
      1,
      0.123903,
      3,
      NULL,
      NULL,
      1.018873,
      5,
      3,
      0,
      0,
      1,
      5,
      2,
      2.504131,
      0.459862,
      4,
      3.930133,
      0,
      4,
      5,
      NULL,
      2.641901,
      1,
      NULL,
      NULL,
      0.895942,
      0.332138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.130606,
      0,
      1,
      0,
      0.656172,
      0.719054,
      0.585439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1.335508,
      2.275000,
      0.944677,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.206454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.865096,
      0.704910,
      5.433269,
      2.489143,
      1,
      2.286727,
      1,
      NULL,
      NULL,
      1,
      1.205292,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2.043908,
      2,
      0,
      0,
      NULL,
      0.789037,
      1,
      NULL,
      0.615068,
      NULL,
      1.982485,
      0,
      NULL,
      1,
      1,
      NULL,
      0.402632,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '23020',
      NULL,
      '',
      1.388113,
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      5.172646,
      NULL,
      2,
      3,
      1,
      1,
      1,
      2,
      2.822983);
commit;
end;
/


