set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-10-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '110',
      '03032412',
      56,
      44.297402,
      NULL,
      111.336457,
      3,
      0.650263,
      1,
      '241230',
      NULL,
      ' 4-22-2001',
      28.953906,
      NULL,
      0.502096,
      NULL,
      4,
      1.631094,
      1,
      NULL,
      1.298182,
      0.845259,
      0.434067,
      NULL,
      1.242950,
      0,
      1.181616,
      NULL,
      0,
      NULL,
      4.166945,
      0,
      3,
      NULL,
      3,
      0.438073,
      1.952699,
      0.912848,
      4.440076,
      0,
      NULL,
      0.849552,
      NULL,
      1.613768,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.927986,
      0.040730,
      0,
      0,
      0.163536,
      0.474982,
      3,
      NULL,
      1,
      NULL,
      1,
      0,
      0.080838,
      3,
      1,
      NULL,
      0.325001,
      2,
      1,
      1.491626,
      0,
      0,
      5,
      1,
      0,
      NULL,
      0.103630,
      NULL,
      NULL,
      1.228438,
      NULL,
      NULL,
      0,
      NULL,
      0.362486,
      1.227798,
      NULL,
      1,
      5.890529,
      0,
      1.776571,
      NULL,
      1,
      NULL,
      0.691593,
      NULL,
      0,
      1,
      1.245640,
      1.189544,
      NULL,
      NULL,
      NULL,
      2.497860,
      NULL,
      1,
      0,
      0.994812,
      5.067749,
      0.323024,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      0.693963,
      1.151708,
      5,
      0.969921,
      3.904637,
      NULL,
      2,
      0,
      3,
      5,
      2,
      3,
      NULL,
      0,
      NULL,
      NULL,
      3.759359,
      1.329914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.071074,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      3.615050,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.424639,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.777346,
      0,
      NULL,
      0.152788,
      0,
      3.837924,
      1.007556,
      NULL,
      NULL,
      1,
      5.189366,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.586465,
      3.599787,
      0.491455,
      NULL,
      1.153048,
      0.266113,
      0,
      1.381441,
      NULL,
      1.450940,
      1.935235,
      0.935704,
      1,
      0.172740,
      0,
      0.161415,
      0.640050,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '20444',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      1.928658,
      1,
      3,
      NULL,
      NULL,
      0,
      2.270777,
      3.800548);
commit;
end;
/


