set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '014',
      '22142102',
      79,
      11,
      '0221204',
      12,
      3,
      NULL,
      0,
      NULL,
      1,
      '10-27-1985',
      33,
      13,
      0.907014,
      NULL,
      14,
      0.503606,
      1.135757,
      1.715556,
      0.712410,
      NULL,
      0,
      NULL,
      0.156098,
      0.125313,
      NULL,
      0.026774,
      1,
      4.106949,
      0,
      1.854825,
      1,
      1.095767,
      1,
      1,
      0,
      0.428419,
      2,
      0,
      NULL,
      1.010475,
      NULL,
      NULL,
      NULL,
      NULL,
      1.421479,
      NULL,
      NULL,
      2.541062,
      0,
      0.025003,
      1.352452,
      0.607388,
      0.199930,
      3,
      1,
      NULL,
      3.515886,
      0,
      1.609134,
      1,
      0.329074,
      0,
      NULL,
      0.188878,
      2.776611,
      1,
      NULL,
      0.885722,
      1,
      4.468911,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.092823,
      1,
      1,
      0.666947,
      0,
      3,
      1,
      NULL,
      0.689872,
      0.791876,
      1.159484,
      0.574363,
      0.142563,
      2,
      0,
      1,
      0.790456,
      0.773483,
      0,
      NULL,
      1,
      NULL,
      1,
      2.832573,
      4.541307,
      0,
      4.187748,
      1,
      7,
      NULL,
      0,
      0,
      1,
      0.984794,
      7.772846,
      1,
      1,
      2.979200,
      0,
      NULL,
      0.190152,
      NULL,
      3.696428,
      NULL,
      4.194667,
      4,
      NULL,
      3.434119,
      1.578523,
      NULL,
      NULL,
      4.838319,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      1.904826,
      NULL,
      0.729666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      7,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.654666,
      6,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      0.672131,
      5.042193,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0.318042,
      3.938070,
      0,
      3,
      0.010089,
      1.805108,
      NULL,
      0,
      1.651342,
      NULL,
      0,
      0.069502,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.744709,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.300182,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      3,
      3.676611,
      3.361159,
      0,
      2.072245,
      3.498351,
      0,
      2.946444,
      3);
commit;
end;
/


