set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-12-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '233',
      NULL,
      55,
      6,
      NULL,
      96,
      6,
      0.380879,
      0,
      '133340',
      0.328239,
      ' 1-20-1984',
      16,
      48,
      1.170890,
      NULL,
      16.730185,
      NULL,
      2,
      NULL,
      1.446120,
      1.900592,
      0,
      0,
      3,
      0.053714,
      2.269912,
      NULL,
      0,
      3.242997,
      1,
      1.872656,
      2.109174,
      1,
      1,
      1.063283,
      NULL,
      0.867182,
      4.581930,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0.814961,
      1,
      0,
      1.736166,
      1.493407,
      3,
      1,
      0,
      0,
      0,
      0.156739,
      1.186060,
      0,
      1.827966,
      0.960502,
      NULL,
      3,
      2,
      NULL,
      NULL,
      0.069991,
      5,
      1,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0.700172,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      1.517188,
      1.515212,
      1.484592,
      0.132560,
      1.894786,
      0.276957,
      1.272908,
      1,
      1.492111,
      NULL,
      1.303485,
      NULL,
      NULL,
      1.370813,
      7,
      0,
      NULL,
      3.150139,
      NULL,
      1.182827,
      0.637035,
      NULL,
      0.146905,
      NULL,
      0.436411,
      2,
      2,
      NULL,
      1,
      NULL,
      3,
      5.600260,
      4.330035,
      0,
      0,
      4.786362,
      2.989151,
      NULL,
      0.383837,
      5.518397,
      3.945860,
      1,
      NULL,
      NULL,
      7.880317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.160521,
      NULL,
      1,
      0,
      1.825115,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0.225915,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.736087,
      NULL,
      NULL,
      NULL,
      NULL,
      0.208326,
      5.104171,
      4.542352,
      NULL,
      NULL,
      2,
      2,
      1.313640,
      NULL,
      NULL,
      0,
      0,
      1.948720,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.507546,
      0,
      0.131032,
      1.500868,
      1,
      1,
      0,
      1,
      NULL,
      0,
      0.653002,
      0,
      1,
      1,
      1.697259,
      0,
      0.486867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.306904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.610239,
      '43134',
      '',
      '',
      0.014635,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0,
      2,
      2,
      NULL,
      2,
      0,
      2.125404,
      1,
      2);
commit;
end;
/


