set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-5-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4114',
      '20410402',
      36.723267,
      13,
      '0443223',
      221,
      6,
      NULL,
      0,
      '024114',
      4.500479,
      ' 5-13-1974',
      21,
      NULL,
      NULL,
      NULL,
      12.197756,
      1,
      0.253924,
      NULL,
      0.509669,
      3,
      0,
      1,
      2.723801,
      0,
      4,
      0,
      0,
      1,
      0,
      1.526444,
      2.816965,
      0.924459,
      0.869108,
      1.085755,
      0.113886,
      0.290510,
      NULL,
      1,
      NULL,
      1,
      0.651227,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.323986,
      0.309683,
      0.626609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.253112,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.522550,
      0,
      NULL,
      0,
      1,
      NULL,
      4,
      NULL,
      3.562919,
      NULL,
      0,
      2.683905,
      0,
      1,
      1.868314,
      0,
      NULL,
      1.375353,
      NULL,
      NULL,
      1,
      6.965125,
      0.525497,
      2,
      3,
      1.060011,
      5.750781,
      1,
      1,
      NULL,
      1.364554,
      1.562004,
      4,
      NULL,
      4.842873,
      0,
      4.724323,
      NULL,
      0,
      5.765454,
      0,
      NULL,
      5,
      2.509463,
      NULL,
      6.672067,
      5.684658,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.719626,
      0.433565,
      1,
      NULL,
      1.203805,
      1.953562,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.547800,
      1,
      1.525512,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.759705,
      1,
      1.169437,
      NULL,
      NULL,
      NULL,
      4,
      1,
      0,
      0,
      0,
      1,
      2.071992,
      1.261365,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.264435,
      0.923505,
      3.383926,
      0,
      1.108997,
      0,
      NULL,
      3,
      NULL,
      NULL,
      0,
      1.189764,
      1,
      0.395503,
      0,
      1.733365,
      1.621639,
      0,
      NULL,
      1.292264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.111135,
      '04433',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      2,
      5,
      1,
      2.320387,
      3.361832,
      3.802364,
      1.581940,
      3,
      1.477314);
commit;
end;
/


