set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2330',
      '40431210',
      73,
      NULL,
      NULL,
      64,
      5,
      NULL,
      0,
      '241342',
      NULL,
      NULL,
      NULL,
      26,
      1,
      NULL,
      18,
      1.439599,
      0,
      1,
      0,
      3.759777,
      0,
      1.751865,
      2,
      0.238679,
      5,
      0.176355,
      3,
      5.690894,
      1,
      1.934083,
      5.579166,
      1,
      0.783937,
      1.291228,
      3,
      0,
      2.685009,
      NULL,
      0,
      2.480678,
      0.986254,
      1.063749,
      NULL,
      NULL,
      2,
      NULL,
      2,
      0.097502,
      3,
      1,
      3,
      0,
      1.251623,
      2.268801,
      1,
      NULL,
      0.219305,
      3.011540,
      0.543445,
      0.048602,
      3,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      4,
      0,
      NULL,
      3,
      1,
      NULL,
      NULL,
      3,
      1,
      3.052758,
      0.868295,
      0,
      0.502258,
      NULL,
      0,
      0.621628,
      NULL,
      0.636398,
      NULL,
      0.236456,
      0.523384,
      NULL,
      0,
      1,
      1.917076,
      1.990719,
      0.228028,
      0,
      1,
      NULL,
      NULL,
      0.616648,
      NULL,
      1.893381,
      NULL,
      NULL,
      7.783824,
      0.438433,
      NULL,
      4,
      0,
      1,
      4.409253,
      2,
      NULL,
      0.669500,
      0,
      2.225720,
      2.911078,
      7.168617,
      0,
      7.196883,
      5,
      0,
      3.527422,
      4,
      1,
      NULL,
      1.875876,
      2,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      0.314135,
      0.278347,
      1.161553,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.274752,
      3,
      1,
      NULL,
      2,
      2,
      NULL,
      1,
      1,
      3,
      0.638551,
      1.290039,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.797404,
      0,
      2,
      NULL,
      3.515139,
      0,
      NULL,
      NULL,
      1,
      7,
      0.346736,
      1,
      NULL,
      4,
      4.668982,
      3,
      1.660492,
      0,
      NULL,
      0,
      NULL,
      1,
      3,
      1.499870,
      2,
      0,
      NULL,
      NULL,
      1.498614,
      0,
      1.310438,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.121037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '21004',
      '',
      NULL,
      1,
      '',
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      5.837993,
      2.037035,
      2.539852,
      3.749191,
      3.681219,
      3.080931,
      2.393767,
      1.146983,
      NULL);
commit;
end;
/


