set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-12-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2211',
      '31404343',
      NULL,
      69,
      '3332110',
      203.556995,
      2,
      1,
      1,
      '422342',
      1.057715,
      ' 3- 9-1983',
      7.111916,
      40,
      1.892446,
      NULL,
      0,
      1.180135,
      2.947119,
      0.997503,
      1,
      NULL,
      NULL,
      0.362374,
      NULL,
      0,
      0.671673,
      1.804018,
      NULL,
      2.134407,
      2,
      1.557006,
      4,
      1.266564,
      0.615623,
      0.540909,
      NULL,
      1,
      3,
      NULL,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.157794,
      NULL,
      NULL,
      1,
      1.157497,
      3,
      NULL,
      0,
      1,
      1,
      3,
      3,
      1.076263,
      1.431641,
      0.337959,
      NULL,
      NULL,
      1.614675,
      2,
      0.297639,
      0.239916,
      0,
      NULL,
      0,
      0,
      4,
      NULL,
      0,
      3,
      1.675011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.047866,
      NULL,
      1.917352,
      0,
      1,
      1.309356,
      1,
      1.747767,
      0.332761,
      0.549386,
      3,
      0.820702,
      1,
      0,
      NULL,
      NULL,
      0.151942,
      1,
      NULL,
      0,
      7.712114,
      0.504789,
      NULL,
      2.778723,
      1.034930,
      NULL,
      NULL,
      0.624881,
      2.887815,
      5.907463,
      0,
      2.639424,
      5,
      5.657205,
      1.846565,
      1,
      7,
      0,
      1,
      1,
      5,
      NULL,
      5.597191,
      3.911399,
      NULL,
      10,
      0,
      0.204591,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.093882,
      1,
      0.092579,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.390376,
      NULL,
      1,
      0.298832,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.577617,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.971097,
      4.077729,
      4.074443,
      5.913248,
      0,
      0.873466,
      1.577736,
      NULL,
      NULL,
      1.391759,
      NULL,
      1.637861,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.518842,
      2,
      3,
      2,
      1.884699,
      2.086345,
      NULL,
      3,
      0.887007,
      1,
      1.432951,
      0.255550,
      1.776472,
      0.178811,
      1.551299,
      NULL,
      1.399571,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '21433',
      '',
      '',
      1,
      '',
      '',
      '',
      0.190628,
      '',
      '',
      '',
      NULL,
      3.578834,
      2.998929,
      1,
      3.493590,
      NULL,
      0,
      1,
      NULL);
commit;
end;
/


