set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-7-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3111',
      '40014302',
      80,
      31.795534,
      NULL,
      105.490286,
      5,
      3,
      NULL,
      '212011',
      NULL,
      '11-14-1995',
      80,
      13,
      0,
      NULL,
      1,
      0.892882,
      0,
      0,
      0,
      0,
      0,
      0.806612,
      1,
      1.214268,
      1,
      0,
      0,
      0,
      1.359201,
      1.092279,
      5.367311,
      1,
      2.641043,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2.426064,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.646754,
      3.701786,
      2.793885,
      0.190508,
      2.517978,
      3.809254,
      1.459765,
      3,
      2,
      NULL,
      2,
      1,
      2,
      0.523264,
      2.660489,
      0.749273,
      1.601524,
      0,
      1,
      0,
      NULL,
      1,
      1,
      2,
      2,
      0.917148,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.947689,
      0.581035,
      NULL,
      1,
      1,
      NULL,
      0.943783,
      1.365452,
      0,
      0,
      NULL,
      0,
      0.105439,
      0.606034,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      2,
      1,
      0.102452,
      NULL,
      3.131396,
      NULL,
      1.853817,
      2,
      3.316990,
      3.626021,
      NULL,
      1.215212,
      NULL,
      7.661191,
      NULL,
      1.247610,
      2,
      0.175886,
      NULL,
      5,
      NULL,
      3.135140,
      5,
      2,
      NULL,
      NULL,
      4,
      0.688009,
      NULL,
      NULL,
      5.497844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.771615,
      1.700344,
      1,
      0,
      0.957159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.234143,
      NULL,
      0.346437,
      5,
      2.774316,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      1.643683,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.334910,
      1.557277,
      NULL,
      NULL,
      3.562158,
      0.516388,
      0.766624,
      NULL,
      1,
      0.427614,
      1,
      1,
      1.874089,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.399058,
      '00320',
      NULL,
      NULL,
      1.515842,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      2.383213,
      NULL,
      1.686132,
      NULL,
      2.517093,
      3.300018,
      3.292959,
      0.998298);
commit;
end;
/


