set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9011057';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-5-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '4',
      NULL,
      NULL,
      '2333103',
      31,
      6,
      2,
      2,
      '014000',
      1.582294,
      NULL,
      11.716885,
      NULL,
      0,
      NULL,
      0,
      0.307023,
      0,
      0,
      0.487412,
      NULL,
      0.474597,
      0.100227,
      NULL,
      0.164976,
      1.773691,
      1,
      1,
      1.733728,
      1,
      NULL,
      0.768305,
      0,
      0.022735,
      0.547005,
      1,
      0.219041,
      0.133912,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.994184,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.665721,
      0.460547,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.005847,
      0,
      NULL,
      NULL,
      1,
      0.607952,
      0.534608,
      0,
      0.626243,
      0,
      1.976615,
      1.032722,
      1.352449,
      0,
      NULL,
      1.998633,
      0.237812,
      0,
      0,
      0,
      1.388957,
      3.193084,
      1,
      NULL,
      0.650730,
      5,
      1.271038,
      0.633499,
      0,
      NULL,
      NULL,
      1,
      3,
      4,
      4,
      6,
      6,
      0,
      5.880378,
      NULL,
      NULL,
      6,
      4.808669,
      0.102561,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      1,
      1,
      0.048392,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      7.433075,
      1.355854,
      1.816311,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      3.016260,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3.357782,
      NULL,
      0.438418,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.360153,
      NULL,
      1,
      0,
      2.476598,
      NULL,
      3,
      1,
      0.356358,
      1,
      1.433103,
      2.030734,
      3,
      1,
      1,
      0.523908,
      NULL,
      1,
      NULL,
      NULL,
      0.633014,
      1.051815,
      1,
      NULL,
      3,
      1.508696,
      3.813287,
      0.163165,
      1,
      NULL,
      3.186683,
      0,
      2,
      NULL,
      NULL,
      3,
      0,
      1,
      0.463708,
      1.154674,
      1,
      1.293032,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      '24421',
      '40324',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


