set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531891';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-7-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '22042233',
      25,
      NULL,
      NULL,
      35,
      NULL,
      2.857319,
      1,
      '214243',
      0,
      ' 5-23-1986',
      11,
      42,
      1,
      NULL,
      1.083763,
      1.309377,
      1.260233,
      0,
      1.598854,
      0,
      0.424675,
      1.860217,
      0.926315,
      NULL,
      1,
      1,
      1,
      0,
      0,
      1,
      0.193187,
      0,
      1.535977,
      1.032062,
      1.633986,
      NULL,
      1.685365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.577431,
      1.926059,
      1.492448,
      1.479267,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.015604,
      1.571841,
      0,
      0.045299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.631700,
      1.642603,
      0,
      NULL,
      NULL,
      1.035796,
      1,
      0.007729,
      1,
      1,
      1.136051,
      0.924777,
      1.801538,
      0.256552,
      0.321232,
      1.187530,
      NULL,
      0,
      NULL,
      0,
      0.786758,
      1.737802,
      1,
      1,
      1,
      1,
      3.036917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.779362,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      9,
      3,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.481636,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.012980,
      0,
      0.674953,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.153885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.071085,
      0.910429,
      NULL,
      NULL,
      NULL,
      1,
      1.965778,
      NULL,
      1.889569,
      1.706162,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.662374,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.002730,
      0.436331,
      1.145738,
      0.553839,
      NULL,
      1,
      NULL,
      1.304626,
      0.263290,
      NULL,
      0,
      1.522598,
      0,
      NULL,
      NULL,
      1,
      0.255238,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.543297,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.931195,
      '34023',
      NULL,
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      1.080098,
      1,
      0,
      1,
      1.332104,
      3.069361,
      1.986117,
      0.996646,
      0);
commit;
end;
/


