set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531891';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-7-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3241',
      '22122124',
      0,
      30.789468,
      '3302141',
      132,
      5,
      1,
      3,
      '100330',
      1.153451,
      ' 4- 6-2001',
      3,
      195.563797,
      0,
      NULL,
      0,
      0.083101,
      0,
      0,
      1,
      0.838830,
      0,
      3.943853,
      NULL,
      NULL,
      0.376486,
      1,
      NULL,
      1,
      0,
      1,
      1.090119,
      NULL,
      0.735936,
      NULL,
      0.980680,
      1.807623,
      4.950223,
      0,
      1,
      3.296839,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.284963,
      1,
      0.206978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.956379,
      0.436409,
      0.019577,
      0,
      1,
      1,
      1,
      1,
      0.066624,
      0.185445,
      0,
      1,
      0.287820,
      1,
      NULL,
      0.891782,
      1.015932,
      0.416025,
      0.429993,
      NULL,
      1,
      2.406316,
      NULL,
      1,
      3,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.333306,
      0.450481,
      2.220530,
      0,
      1,
      2,
      1,
      NULL,
      7,
      NULL,
      3.306718,
      NULL,
      3.373660,
      NULL,
      1,
      1.381516,
      1,
      NULL,
      NULL,
      2.325315,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.403434,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      0.167219,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      9.038206,
      1.736098,
      0.320798,
      1.493921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.387526,
      1.009001,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5,
      0,
      2.725128,
      0,
      0.251893,
      NULL,
      NULL,
      NULL,
      1.420884,
      2.502699,
      0.208789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.510237,
      NULL,
      0,
      1,
      2,
      2,
      1.529206,
      1.077623,
      3,
      0.901663,
      0,
      NULL,
      0,
      0.280146,
      0.189116,
      0.627261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '33001',
      '',
      '',
      0.160778,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      5,
      1.740297,
      0,
      4,
      1,
      2.248777,
      0,
      2.394893,
      NULL);
commit;
end;
/


