set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8326935';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-9-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '342',
      '30',
      23.709019,
      NULL,
      '2414241',
      NULL,
      5,
      2.986493,
      3,
      '030144',
      0,
      ' 8-22-1995',
      6,
      20,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      1.720075,
      3.748881,
      1.711891,
      0,
      1,
      NULL,
      1.859759,
      2,
      1,
      NULL,
      NULL,
      5,
      1.745589,
      0,
      2.492122,
      0.638443,
      1.458400,
      1,
      0,
      3.209041,
      0.391097,
      2,
      1.677515,
      NULL,
      NULL,
      1.761682,
      NULL,
      NULL,
      0,
      1.380984,
      1.390792,
      0.237515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.255983,
      NULL,
      0.641774,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.133946,
      0,
      NULL,
      NULL,
      3,
      2.144822,
      1,
      1.414764,
      1.428114,
      2,
      0.952724,
      0,
      0.173946,
      NULL,
      1.184007,
      NULL,
      NULL,
      1.562539,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      3,
      0,
      4,
      2.401155,
      0,
      0,
      5.770970,
      2.237894,
      5.132877,
      NULL,
      0,
      NULL,
      NULL,
      1.309848,
      NULL,
      2.455881,
      4.147142,
      NULL,
      2.531872,
      NULL,
      0.836612,
      0.403644,
      0,
      NULL,
      NULL,
      2.076493,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.290114,
      0,
      0,
      0,
      1,
      0.503275,
      1.008543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      5.881641,
      0,
      NULL,
      0.379188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.177883,
      0,
      NULL,
      1.789589,
      0,
      1.568132,
      0.910487,
      3,
      1.227587,
      0,
      1.301587,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.970031,
      NULL,
      1.653490,
      NULL,
      1.196061,
      NULL,
      3,
      NULL,
      0,
      0.406326,
      0,
      1.198345,
      0,
      1,
      0.628997,
      NULL,
      0.666877,
      1.979917,
      0.797827,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '12131',
      '',
      NULL,
      0,
      '',
      '',
      '',
      0.424450,
      '',
      '',
      '',
      3.751374,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


