set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8326935';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '132',
      '00',
      NULL,
      8.120576,
      '1004034',
      45,
      5,
      1,
      0,
      '331011',
      3.763653,
      ' 3- 9-1988',
      44,
      9.264924,
      NULL,
      NULL,
      1.901925,
      1,
      0.322762,
      1,
      1,
      0.195840,
      2.613852,
      0.354437,
      0.499307,
      1,
      0,
      NULL,
      4.153383,
      1.136878,
      3.214074,
      1.943046,
      3,
      NULL,
      1,
      0.244714,
      7.477758,
      NULL,
      2.147870,
      1,
      3,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5,
      0,
      1,
      1,
      NULL,
      0.417662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.989119,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.320002,
      1.753209,
      1.103436,
      3,
      0,
      0.061537,
      0,
      2,
      1,
      0.205607,
      0.735802,
      5,
      0.445365,
      1,
      1,
      1.016354,
      0.230987,
      NULL,
      1,
      4,
      1,
      1,
      0.800609,
      0.000668,
      1.653862,
      1,
      5.620493,
      0.925330,
      5,
      0,
      5,
      NULL,
      3.962428,
      1.067885,
      1.377860,
      NULL,
      9,
      4,
      1.869488,
      4.230771,
      2,
      2,
      0,
      1,
      3,
      0.093560,
      NULL,
      1.990308,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.786783,
      1,
      0,
      1,
      1.996077,
      1,
      0.732442,
      0.772673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.335332,
      0.117611,
      0.359502,
      1.798657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1.481283,
      2.576854,
      1.909170,
      NULL,
      1.210499,
      NULL,
      5,
      6.895796,
      0,
      6.126406,
      0,
      NULL,
      NULL,
      2.325313,
      NULL,
      3.018732,
      3.001754,
      1.573189,
      NULL,
      0,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      2.374188,
      1.993588,
      0,
      0,
      1,
      1.714965,
      0.668448,
      3.428584,
      0,
      1.928671,
      NULL,
      1.281013,
      0,
      1,
      0,
      0.264120,
      0,
      0.579725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.495319,
      '40232',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


