set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8326935';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-12-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '04',
      26.902558,
      21,
      '3141103',
      27,
      4,
      2.588481,
      3,
      '434034',
      2.826903,
      ' 2-11-2000',
      45,
      16.498424,
      1,
      NULL,
      0.697951,
      1.519285,
      NULL,
      NULL,
      0.031297,
      0.797467,
      NULL,
      1,
      1,
      1.000118,
      7,
      0.631595,
      6,
      1.416003,
      0.592598,
      0.453631,
      2.748854,
      NULL,
      1,
      5.822695,
      4.877941,
      1.339916,
      4.436597,
      NULL,
      2.494559,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1,
      3.508175,
      1.340854,
      0,
      1,
      1.570748,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.788999,
      0.237546,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.441603,
      1,
      0,
      1.147188,
      0.271346,
      1.621323,
      0.537488,
      NULL,
      3,
      5,
      2,
      1,
      NULL,
      0,
      0.782519,
      0.155159,
      0.756094,
      NULL,
      NULL,
      0.042562,
      2.465727,
      1.404869,
      0.379267,
      1,
      3,
      5,
      1.045029,
      2.224966,
      2,
      4.714869,
      1.618810,
      NULL,
      4,
      NULL,
      0,
      1,
      1,
      3.913858,
      0.243604,
      0,
      NULL,
      0,
      7,
      7.496182,
      2,
      1.549552,
      NULL,
      3,
      1.883900,
      0.925367,
      NULL,
      0.065269,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.191130,
      2,
      0,
      NULL,
      0.480189,
      4.679362,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2.522077,
      1.125980,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.160164,
      1.089229,
      NULL,
      0,
      0.726229,
      0,
      0,
      4.750121,
      3,
      4,
      1,
      2,
      2.063434,
      0,
      NULL,
      NULL,
      1.571892,
      1.424059,
      1.911840,
      5.040941,
      5,
      4,
      NULL,
      0.094864,
      NULL,
      1,
      3,
      1,
      1.642742,
      0.956984,
      NULL,
      2,
      1,
      1,
      1,
      0,
      NULL,
      1,
      1,
      0,
      1,
      1.615951,
      1,
      1.289775,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.417126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.972555,
      '23101',
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      0.095641,
      '',
      NULL,
      NULL,
      1.032668,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


