set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8326935';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-5-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '443',
      '32',
      NULL,
      6,
      '1140044',
      35,
      2,
      3.953448,
      NULL,
      '204024',
      1,
      ' 1-28-1976',
      NULL,
      57,
      1.012286,
      NULL,
      0,
      3,
      0,
      0.018771,
      NULL,
      0.063720,
      1.237237,
      1,
      1,
      1,
      0.286448,
      NULL,
      0.300165,
      0.059166,
      1.779147,
      NULL,
      2.940602,
      0.119416,
      6,
      NULL,
      5.014399,
      1,
      1.721200,
      0,
      1,
      NULL,
      2.964673,
      NULL,
      NULL,
      NULL,
      3,
      5,
      0.853951,
      1,
      0.202133,
      1,
      0.649135,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.350081,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.625764,
      10,
      0.557880,
      4.342445,
      NULL,
      5.529011,
      5,
      0.491605,
      0.382702,
      3.290832,
      4.389810,
      4,
      NULL,
      1.047230,
      4.096163,
      2.203556,
      1.853168,
      0,
      NULL,
      0.352944,
      9,
      5.728403,
      1,
      3.269952,
      1,
      4,
      0,
      0.677055,
      3.007397,
      2.572084,
      NULL,
      0.113750,
      3,
      2,
      NULL,
      1.818458,
      0,
      NULL,
      NULL,
      7.100871,
      7,
      6,
      NULL,
      1.557269,
      2.199190,
      0.904420,
      2.342432,
      0,
      2.135941,
      1,
      1,
      NULL,
      1.835794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.025703,
      5.929738,
      1,
      0,
      NULL,
      1.619572,
      5.550010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.668620,
      NULL,
      9.642991,
      2,
      NULL,
      0.849389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.957275,
      NULL,
      1,
      1,
      NULL,
      1.703816,
      4.420952,
      2,
      1.723962,
      NULL,
      2,
      NULL,
      1.066547,
      NULL,
      NULL,
      NULL,
      NULL,
      1.200094,
      NULL,
      0,
      1.912505,
      5.579854,
      0,
      0,
      NULL,
      1.656089,
      1,
      2,
      2,
      NULL,
      NULL,
      0,
      2.573401,
      NULL,
      NULL,
      0.884883,
      NULL,
      1.507537,
      1,
      0,
      0,
      NULL,
      0,
      0.510058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '31033',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


