set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8326935';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-3-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '001',
      '01',
      0.996930,
      12,
      '0301401',
      3,
      6,
      0,
      3,
      NULL,
      4.804294,
      ' 2-26-1986',
      30,
      5,
      0,
      NULL,
      0.965880,
      2.809344,
      NULL,
      1,
      1.228822,
      NULL,
      0.347532,
      0,
      1.800153,
      NULL,
      3,
      0.595442,
      NULL,
      1.663757,
      3,
      1.549990,
      5,
      NULL,
      NULL,
      NULL,
      0.681005,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.417083,
      NULL,
      NULL,
      0.063741,
      NULL,
      NULL,
      0.286867,
      1,
      0.205580,
      1.355803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.238742,
      0,
      5.171066,
      NULL,
      1.348986,
      0.844028,
      NULL,
      2.679530,
      2.331777,
      NULL,
      0,
      4.221132,
      0.347790,
      1.883559,
      0.237241,
      1.719598,
      NULL,
      NULL,
      0,
      0.160635,
      1,
      3,
      3,
      4,
      2.541600,
      0,
      0.659970,
      1.308511,
      NULL,
      0.366737,
      4,
      2,
      0,
      1.367030,
      1,
      2,
      NULL,
      1.971455,
      3,
      NULL,
      2,
      4,
      5,
      4,
      1.197856,
      4.196939,
      NULL,
      1,
      NULL,
      3.149264,
      1.475835,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.376283,
      0,
      1,
      NULL,
      4.696988,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      9.826233,
      2,
      NULL,
      1.798087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.414055,
      2.841767,
      0,
      NULL,
      NULL,
      NULL,
      0.566467,
      0.872356,
      5.642609,
      0.462695,
      2,
      1,
      1.454496,
      NULL,
      NULL,
      NULL,
      1.902073,
      4.533455,
      1.052834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.892001,
      0,
      NULL,
      2.400897,
      NULL,
      NULL,
      NULL,
      0.570944,
      2,
      1,
      NULL,
      1.792102,
      NULL,
      0.112088,
      1,
      1,
      1.358617,
      0.760375,
      1.000868,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '21033',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0.035521,
      '',
      '',
      NULL,
      2.621070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


