set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8326935';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-4-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '30320333',
      22.510725,
      53.080898,
      '3332101',
      NULL,
      NULL,
      0,
      2,
      NULL,
      0,
      ' 7-25-2000',
      48,
      NULL,
      0,
      NULL,
      NULL,
      2.908199,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      3,
      1,
      1,
      0,
      0.335357,
      6.940873,
      NULL,
      3,
      10,
      1.470352,
      6.618231,
      5,
      1.292347,
      0.650696,
      NULL,
      NULL,
      3,
      0.106565,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.681931,
      NULL,
      1.395407,
      1.133675,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.557977,
      0.499176,
      2.877081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.902687,
      1.963669,
      3.200241,
      3.848879,
      4,
      1.250593,
      4.946785,
      1,
      0,
      0.915727,
      0.331541,
      2,
      0,
      1.141437,
      0.802937,
      1,
      0.679316,
      1.547688,
      1,
      NULL,
      1.052521,
      1,
      NULL,
      3.976914,
      3.629388,
      5.463520,
      5,
      0,
      1,
      NULL,
      1.532731,
      0.320130,
      1.652195,
      NULL,
      4.864981,
      0.131710,
      NULL,
      5.237961,
      4,
      1,
      2.532755,
      NULL,
      NULL,
      7,
      NULL,
      4.801525,
      5.337243,
      0.716897,
      NULL,
      1,
      0,
      2.600493,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.368781,
      0.457170,
      1,
      0,
      1.374576,
      1,
      1,
      3.939620,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.008189,
      NULL,
      NULL,
      NULL,
      NULL,
      1.627301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.161013,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.560474,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1,
      1,
      1,
      1.743378,
      1,
      2.382155,
      3.271121,
      0,
      NULL,
      1.195776,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.801084,
      0.514488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.915857,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.519734,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      4.574071,
      3.666788,
      3,
      0,
      1.847508,
      1.154774,
      3.038728,
      NULL,
      0);
commit;
end;
/


