set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8326935';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-10-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '110',
      '21411202',
      25,
      4,
      '4242344',
      99,
      1,
      3,
      3,
      '033131',
      2.220939,
      '10-17-2002',
      21.490230,
      36,
      0.074006,
      NULL,
      NULL,
      1,
      NULL,
      1.556767,
      1.120118,
      NULL,
      0.286626,
      3,
      2,
      0.262538,
      4,
      0.852533,
      0,
      3,
      7.338014,
      3.723525,
      10,
      1.934485,
      4.429500,
      8,
      4.958046,
      0.266512,
      0.352416,
      1,
      3,
      NULL,
      1.734067,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.157473,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.655086,
      NULL,
      0,
      2,
      NULL,
      4,
      0.357440,
      NULL,
      0.643038,
      0.569767,
      3.521935,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.087531,
      0.267284,
      NULL,
      1.199796,
      1.643709,
      1,
      4,
      3,
      3.734373,
      NULL,
      1.224370,
      NULL,
      2.386728,
      3.243898,
      1,
      3,
      3,
      4.721972,
      1.731230,
      1,
      5,
      NULL,
      1,
      NULL,
      4.451081,
      4.736947,
      2,
      NULL,
      3,
      0,
      7,
      0.576079,
      1.053544,
      1,
      2,
      1.466623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2,
      NULL,
      3,
      1.185688,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.545913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.962940,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.789125,
      1.018974,
      NULL,
      0.500524,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.496219,
      0.874015,
      0.232577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.979958,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      3,
      1.822495,
      0,
      0,
      0,
      1,
      1,
      0.482758,
      NULL,
      1.222759,
      0.680005,
      1,
      0.199046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      '',
      NULL,
      1.062498,
      '',
      '',
      '',
      1.166988,
      '',
      '',
      '',
      1,
      2.118272,
      0.648164,
      1.925947,
      1.946560,
      1,
      2,
      1,
      NULL);
commit;
end;
/


