set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8326935';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-3-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '413',
      '24343231',
      NULL,
      NULL,
      '0441141',
      51.665491,
      NULL,
      0.668968,
      1,
      NULL,
      4,
      ' 7-21-2000',
      17,
      58,
      1.904569,
      NULL,
      0,
      NULL,
      0,
      1.162083,
      0.356231,
      0,
      0.532159,
      2,
      1.328000,
      1,
      1.541335,
      0.224134,
      NULL,
      3.090562,
      6.892043,
      3,
      6.812660,
      1.137616,
      3,
      7.636360,
      1,
      0,
      8,
      0,
      5.148021,
      NULL,
      0.155154,
      0,
      NULL,
      NULL,
      1.018729,
      NULL,
      NULL,
      1.789077,
      NULL,
      1.229599,
      0.584760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.285519,
      1,
      3,
      NULL,
      0,
      NULL,
      1.711002,
      0,
      2,
      3.108100,
      0.661248,
      NULL,
      NULL,
      1.574445,
      NULL,
      0.777385,
      1,
      NULL,
      NULL,
      NULL,
      0.022491,
      1,
      NULL,
      0,
      4,
      1,
      3.261922,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      1.824232,
      1,
      0.383220,
      NULL,
      2,
      NULL,
      3,
      0,
      NULL,
      3.200913,
      1.151338,
      0,
      2,
      3,
      NULL,
      1,
      2,
      0.451078,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      1.976476,
      0,
      0.372651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.983728,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.357613,
      1.284415,
      2.894359,
      0.728550,
      0.122425,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.014411,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.145512,
      2,
      1,
      0.947717,
      2,
      0.851355,
      0.563226,
      1,
      1,
      0.190946,
      1,
      1.613085,
      1,
      1.828589,
      1.400005,
      NULL,
      1,
      0.973366,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.518584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.276178,
      '03144',
      '',
      '',
      1.601072,
      '',
      '',
      '',
      1.834719,
      '',
      '',
      '',
      2.565728,
      2.060221,
      0.973008,
      3,
      0,
      0.132996,
      1,
      1,
      0.042376);
commit;
end;
/


