set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8326935';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-9-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '423',
      NULL,
      12.841533,
      6.500712,
      NULL,
      20.414219,
      6,
      3.470201,
      3,
      '401440',
      3.498014,
      ' 4-14-1990',
      57,
      140,
      0,
      NULL,
      0.009637,
      1,
      0,
      0.305744,
      1.672546,
      0.151872,
      1.755312,
      0.970074,
      NULL,
      1.458080,
      4.095635,
      1,
      1,
      3.190018,
      0.727862,
      0,
      7.300280,
      0.394675,
      7.337495,
      3,
      4.692957,
      5.981070,
      NULL,
      1,
      NULL,
      1.162180,
      1,
      1.034263,
      NULL,
      NULL,
      0.118909,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.871943,
      NULL,
      0.727397,
      1.324702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.417890,
      NULL,
      0,
      1.466676,
      3.711133,
      1,
      3.132303,
      0.298451,
      NULL,
      0.534338,
      3.556904,
      0.162071,
      0.961659,
      4.695639,
      NULL,
      0,
      0,
      1.465173,
      0.695197,
      NULL,
      0,
      1.058840,
      1.290384,
      2,
      1,
      4,
      NULL,
      1.348904,
      NULL,
      5,
      2,
      NULL,
      3,
      2.267591,
      1.601305,
      1.661672,
      1.992451,
      NULL,
      3.771118,
      4,
      NULL,
      4.029073,
      4,
      6,
      6,
      4,
      0.855336,
      2,
      2.615047,
      0,
      1.217393,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      0,
      0.706073,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.547277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      2,
      0,
      1.756832,
      0,
      1,
      1.157387,
      NULL,
      1.421362,
      1.768717,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.908494,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.202399,
      1.777129,
      2.442141,
      0,
      3.782373,
      0.769932,
      1.686072,
      3.402912,
      0,
      0,
      0.032024,
      1,
      1,
      1,
      1.706453,
      0,
      0.586063,
      0.122854,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.632473,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.163681,
      NULL,
      '',
      '',
      1.789720,
      NULL,
      '',
      NULL,
      0.511292,
      '',
      '',
      '',
      2.738380,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      0.628167,
      2.804591);
commit;
end;
/


