set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8326935';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-6-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '41133004',
      71,
      NULL,
      '4414244',
      161.860254,
      6,
      NULL,
      0,
      '114014',
      1,
      NULL,
      56,
      105.848159,
      0,
      NULL,
      0.382508,
      0,
      NULL,
      1,
      1,
      NULL,
      1.639250,
      0.276303,
      NULL,
      NULL,
      2,
      0,
      1,
      5.785044,
      0.655225,
      0,
      6.194771,
      NULL,
      2.444002,
      3,
      4,
      8.574031,
      0,
      NULL,
      3,
      2.589470,
      1.818717,
      0.018414,
      NULL,
      NULL,
      1.740792,
      NULL,
      NULL,
      1,
      0.773895,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.631818,
      0,
      0.793648,
      1.609694,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.549248,
      NULL,
      1,
      0.624948,
      3,
      NULL,
      0.153939,
      1.364596,
      5.136459,
      1,
      NULL,
      2.513192,
      0.975727,
      0.667855,
      1,
      1.906710,
      1.305093,
      NULL,
      1,
      1,
      0.873644,
      0,
      1,
      NULL,
      5.991589,
      0.722925,
      NULL,
      5,
      1,
      NULL,
      0,
      2.276560,
      3,
      1.002883,
      1.482310,
      NULL,
      3,
      4,
      3,
      5.768978,
      4,
      0.127131,
      3,
      NULL,
      0.839542,
      2.965790,
      3,
      0,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.989980,
      0,
      0,
      1,
      0.330361,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.982623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.907983,
      0,
      3.305685,
      0.170712,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.082512,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.423534,
      1.661905,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.249946,
      3.845007,
      2.693765,
      1,
      3,
      0.577388,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.667791,
      1.526907,
      0,
      0.911174,
      1.125538,
      NULL,
      1.763664,
      0.179803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.791180,
      NULL,
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1,
      2.283571,
      1.928215,
      1.056841,
      0.777413,
      NULL,
      2.174803,
      NULL,
      0);
commit;
end;
/


