set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8326935';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '411',
      '24443003',
      59,
      63,
      '3313433',
      39.347833,
      NULL,
      1.103839,
      0,
      '331442',
      2,
      NULL,
      54.943754,
      57,
      1.067747,
      NULL,
      1.688377,
      0,
      2.629333,
      1,
      1.223710,
      1,
      1.295428,
      2.264372,
      0,
      NULL,
      7.804100,
      1,
      0,
      3,
      0,
      1.413911,
      6.469783,
      0.142400,
      NULL,
      7.103369,
      5,
      NULL,
      0,
      0,
      1.580653,
      5.295092,
      4.476727,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.631341,
      1,
      0.709744,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.152774,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      4,
      2.952471,
      NULL,
      0.883873,
      0.669991,
      3,
      0.919338,
      NULL,
      5.410237,
      1.459783,
      0.806749,
      1,
      NULL,
      1.397677,
      NULL,
      0,
      1.635594,
      0,
      2.549924,
      NULL,
      5,
      1,
      0,
      5.396583,
      NULL,
      1.038486,
      0.321262,
      NULL,
      NULL,
      NULL,
      1.733797,
      0.146547,
      NULL,
      NULL,
      3.303966,
      3,
      4,
      5,
      4,
      7,
      1,
      4,
      3,
      0,
      0.874975,
      0.363218,
      1.486010,
      1.375876,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.917420,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.265329,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0.370152,
      1.444531,
      1,
      5.995591,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.339179,
      NULL,
      NULL,
      0,
      2,
      0.185288,
      NULL,
      NULL,
      NULL,
      0.129573,
      2.859117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.751504,
      0.178966,
      1,
      1,
      3,
      1,
      0.093309,
      1.335070,
      0,
      1.586984,
      1,
      1.594624,
      1,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.647984,
      '11310',
      '',
      '',
      0.605952,
      '',
      '',
      '',
      1.669850,
      NULL,
      '3202',
      '',
      0.188770,
      1,
      0,
      5.563882,
      3,
      3.029986,
      1.389735,
      NULL,
      0);
commit;
end;
/


